/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.dashboard;

import java.util.Collections;
import java.util.List;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.listener.HeaderLevel;
import org.xwiki.rendering.macro.dashboard.Gadget;
import org.xwiki.rendering.macro.dashboard.GadgetRenderer;

@Component
@Singleton
public class DefaultGadgetRenderer
implements GadgetRenderer {
    protected static final String CLASS = "class";
    protected static final String ID = "id";

    @Override
    public List<Block> decorateGadget(Gadget gadget) {
        HeaderBlock titleBlock = new HeaderBlock(gadget.getTitle(), HeaderLevel.LEVEL1);
        titleBlock.setParameter(CLASS, "gadget-title");
        GroupBlock contentGroup = new GroupBlock();
        contentGroup.setParameter(CLASS, "gadget-content");
        contentGroup.addChildren(gadget.getContent());
        GroupBlock gadgetBlock = new GroupBlock();
        String idPrefix = "gadget";
        gadgetBlock.setParameter(CLASS, idPrefix);
        gadgetBlock.setParameter(ID, idPrefix + "_" + gadget.getId());
        gadgetBlock.addChild((Block)titleBlock);
        gadgetBlock.addChild((Block)contentGroup);
        return Collections.singletonList(gadgetBlock);
    }
}

