/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.diff.xml.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.XWikiRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Base64;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.eviction.LRUEvictionConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.diff.DiffException;
import org.xwiki.diff.xml.internal.DataURIConverter;

@Component
@Singleton
public class DefaultDataURIConverter
implements DataURIConverter,
Initializable {
    private static final String HEADER_COOKIE = "Cookie";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private CacheManager cacheManager;
    private Cache<String> cache;

    public void initialize() throws InitializationException {
        CacheConfiguration cacheConfig = new CacheConfiguration();
        cacheConfig.setConfigurationId("diff.html.dataURI");
        LRUEvictionConfiguration lru = new LRUEvictionConfiguration();
        lru.setMaxEntries(100);
        cacheConfig.put((Object)"eviction", (Object)lru);
        try {
            this.cache = this.cacheManager.createNewCache(cacheConfig);
        }
        catch (Exception e) {
            throw new InitializationException("Failed to create the Data URI cache.", (Throwable)e);
        }
    }

    public String convert(String url) throws DiffException {
        if (url.startsWith("data:")) {
            return url;
        }
        String cachedDataURI = (String)this.cache.get(url);
        if (cachedDataURI == null) {
            try {
                cachedDataURI = this.convert(this.getAbsoluteURI(url));
                this.cache.set(url, (Object)cachedDataURI);
            }
            catch (IOException | URISyntaxException e) {
                throw new DiffException("Failed to convert [" + url + "] to data URI.", (Throwable)e);
            }
        }
        return cachedDataURI;
    }

    private URL getAbsoluteURI(String relativeURL) throws MalformedURLException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        URL baseURL = xcontext.getURLFactory().getServerURL(xcontext);
        return new URL(baseURL, relativeURL);
    }

    private String convert(URL url) throws IOException, URISyntaxException {
        HttpEntity entity = this.fetch(url.toURI());
        String contentType = StringUtils.substringBefore((String)entity.getContentType().getValue(), (String)";");
        byte[] content = IOUtils.toByteArray((InputStream)entity.getContent());
        return String.format("data:%s;base64,%s", contentType, Base64.getEncoder().encodeToString(content));
    }

    private HttpEntity fetch(URI uri) throws IOException {
        CloseableHttpResponse response;
        StatusLine statusLine;
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.useSystemProperties();
        httpClientBuilder.setUserAgent("XWikiHTMLDiff");
        CloseableHttpClient httpClient = httpClientBuilder.build();
        HttpGet getMethod = new HttpGet(uri);
        XWikiRequest request = ((XWikiContext)this.xcontextProvider.get()).getRequest();
        if (request != null) {
            getMethod.setHeader(HEADER_COOKIE, request.getHeader(HEADER_COOKIE));
        }
        if ((statusLine = (response = httpClient.execute((HttpUriRequest)getMethod)).getStatusLine()).getStatusCode() == 200) {
            return response.getEntity();
        }
        throw new IOException(statusLine.getStatusCode() + " " + statusLine.getReasonPhrase());
    }
}

