/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.display.internal;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.context.Execution;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.util.ParserUtils;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityManager;

public abstract class AbstractDocumentTitleDisplayer
implements DocumentDisplayer {
    private static final String DOCUMENT_REFERENCE_STACK_KEY = "internal.displayer.title.documentReferenceStack";
    @Inject
    private Logger logger;
    @Inject
    @Named(value="plain/1.0")
    private Parser plainTextParser;
    @Inject
    private VelocityManager velocityManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    private Execution execution;
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource xwikicfg;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private EntityReferenceProvider defaultEntityReferenceProvider;
    @Inject
    private ModelContext modelContext;
    private ParserUtils parserUtils = new ParserUtils();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XDOM display(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        Map<Object, Object> xwikiContext = this.getXWikiContextMap();
        LinkedList<DocumentReference> documentReferenceStack = (LinkedList<DocumentReference>)xwikiContext.get(DOCUMENT_REFERENCE_STACK_KEY);
        if (documentReferenceStack == null) {
            documentReferenceStack = new LinkedList<DocumentReference>();
            xwikiContext.put(DOCUMENT_REFERENCE_STACK_KEY, documentReferenceStack);
        } else if (documentReferenceStack.contains(document.getDocumentReference())) {
            this.logger.warn("Infinite recursion detected while displaying the title of [{}]. Using the document name as title.", (Object)document.getDocumentReference());
            return this.getStaticTitle(document);
        }
        documentReferenceStack.push(document.getDocumentReference());
        try {
            XDOM xDOM = this.displayTitle(document, parameters);
            return xDOM;
        }
        finally {
            documentReferenceStack.pop();
        }
    }

    private XDOM displayTitle(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        String rawTitle = document.getTitle();
        if (!StringUtils.isEmpty((CharSequence)rawTitle)) {
            try {
                String title = rawTitle;
                if (this.authorizationManager.hasAccess(Right.SCRIPT, document.getContentAuthorReference(), (EntityReference)document.getDocumentReference())) {
                    title = this.evaluateTitle(rawTitle, document.getDocumentReference(), parameters);
                }
                return this.parseTitle(title);
            }
            catch (Exception e) {
                this.logger.warn("Failed to interpret title of document [{}].", (Object)document.getDocumentReference(), (Object)e);
            }
        }
        if ("1".equals(this.xwikicfg.getProperty("xwiki.title.compatibility", (Object)"0"))) {
            try {
                XDOM title = this.extractTitleFromContent(document, parameters);
                if (title != null) {
                    return title;
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to extract title from content of document [{}].", (Object)document.getDocumentReference(), (Object)e);
            }
        }
        return this.getStaticTitle(document);
    }

    protected XDOM parseTitle(String title) {
        try {
            XDOM xdom = this.plainTextParser.parse((Reader)new StringReader(title));
            this.parserUtils.removeTopLevelParagraph(xdom.getChildren());
            return xdom;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    protected String evaluateTitle(String title, DocumentReference documentReference, DocumentDisplayerParameters parameters) {
        VelocityEngine velocityEngine;
        StringWriter writer = new StringWriter();
        String namespace = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)(parameters.isTransformationContextIsolated() ? documentReference : this.documentAccessBridge.getCurrentDocumentReference()), new Object[0]);
        try {
            velocityEngine = this.velocityManager.getVelocityEngine();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashMap backupObjects = null;
        boolean canPop = false;
        EntityReference currentWikiReference = this.modelContext.getCurrentEntityReference();
        try {
            if (parameters.isExecutionContextIsolated()) {
                backupObjects = new HashMap();
                this.documentAccessBridge.pushDocumentInContext(backupObjects, documentReference);
                canPop = true;
                this.modelContext.setCurrentEntityReference((EntityReference)documentReference.getWikiReference());
            }
            velocityEngine.evaluate((Context)this.velocityManager.getVelocityContext(), (Writer)writer, namespace, title);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (canPop) {
                this.documentAccessBridge.popDocumentFromContext(backupObjects);
                this.modelContext.setCurrentEntityReference(currentWikiReference);
            }
        }
        return writer.toString();
    }

    private Map<Object, Object> getXWikiContextMap() {
        return (Map)this.execution.getContext().getProperty("xwikicontext");
    }

    @Deprecated
    protected abstract XDOM extractTitleFromContent(DocumentModelBridge var1, DocumentDisplayerParameters var2);

    private XDOM getStaticTitle(DocumentModelBridge document) {
        String documentName = document.getDocumentReference().getName();
        if (this.defaultEntityReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName().equals(documentName)) {
            documentName = document.getDocumentReference().getParent().getName();
        }
        return this.parseTitle(documentName);
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

