/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.display.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.rendering.block.XDOM;

@Component
@Singleton
public class DefaultDocumentDisplayer
implements DocumentDisplayer {
    @Inject
    @Named(value="title")
    private DocumentDisplayer titleDisplayer;
    @Inject
    @Named(value="content")
    private DocumentDisplayer contentDisplayer;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    @Override
    public XDOM display(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        DocumentDisplayer displayer;
        String syntaxId = document.getSyntax().toIdString();
        if (parameters.isTitleDisplayed()) {
            displayer = this.titleDisplayer;
            String titleHint = "title/" + syntaxId;
            if (this.componentManager.hasComponent(DocumentDisplayer.class, titleHint)) {
                try {
                    displayer = (DocumentDisplayer)this.componentManager.getInstance(DocumentDisplayer.class, titleHint);
                }
                catch (ComponentLookupException e) {
                    this.logger.error("Failed to load title document displayer", (Throwable)e);
                }
            }
        } else {
            displayer = this.contentDisplayer;
            String contentHint = "content/" + syntaxId;
            if (this.componentManager.hasComponent(DocumentDisplayer.class, contentHint)) {
                try {
                    displayer = (DocumentDisplayer)this.componentManager.getInstance(DocumentDisplayer.class, contentHint);
                }
                catch (ComponentLookupException e) {
                    this.logger.error("Failed to load content document displayer", (Throwable)e);
                }
            }
        }
        return displayer.display(document, parameters);
    }
}

