/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.display;

import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.display.DisplayMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="display")
@Singleton
public class DisplayMacro
extends AbstractMacro<DisplayMacroParameters> {
    private static final String DESCRIPTION = "Display other pages into the current page.";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    @Named(value="macro")
    private EntityReferenceResolver<String> macroEntityReferenceResolver;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    @Named(value="configured")
    private DocumentDisplayer documentDisplayer;
    private ThreadLocal<Stack<Object>> displaysBeingExecuted = new ThreadLocal();

    public DisplayMacro() {
        super("Display", DESCRIPTION, DisplayMacroParameters.class);
        this.setPriority(10);
        this.setDefaultCategory("Content");
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public void setDocumentAccessBridge(DocumentAccessBridge documentAccessBridge) {
        this.documentAccessBridge = documentAccessBridge;
    }

    public List<Block> execute(DisplayMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM result;
        DocumentModelBridge documentBridge;
        if (parameters.getReference() == null) {
            throw new MacroExecutionException("You must specify a 'reference' parameter pointing to the entity to display.");
        }
        EntityReference includedReference = this.resolve(context.getCurrentMacroBlock(), parameters);
        this.checkRecursiveDisplay(includedReference);
        try {
            documentBridge = this.documentAccessBridge.getDocumentInstance(includedReference);
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to load Document [" + (String)this.defaultEntityReferenceSerializer.serialize(includedReference, new Object[0]) + "]", (Throwable)e);
        }
        if (!this.authorization.hasAccess(Right.VIEW, (EntityReference)documentBridge.getDocumentReference())) {
            throw new MacroExecutionException(String.format("Current user [%s] doesn't have view rights on document [%s]", this.documentAccessBridge.getCurrentUserReference(), includedReference));
        }
        DocumentDisplayerParameters displayParameters = new DocumentDisplayerParameters();
        displayParameters.setContentTransformed(true);
        displayParameters.setExecutionContextIsolated(displayParameters.isContentTransformed());
        displayParameters.setSectionId(parameters.getSection());
        displayParameters.setTransformationContextIsolated(displayParameters.isContentTransformed());
        displayParameters.setTargetSyntax(context.getTransformationContext().getTargetSyntax());
        displayParameters.setContentTranslated(true);
        Stack<Object> references = this.displaysBeingExecuted.get();
        if (references == null) {
            references = new Stack();
            this.displaysBeingExecuted.set(references);
        }
        references.push(includedReference);
        try {
            result = this.documentDisplayer.display((Object)documentBridge, (Object)displayParameters);
        }
        catch (Exception e) {
            throw new MacroExecutionException(e.getMessage(), (Throwable)e);
        }
        finally {
            references.pop();
            if (references.isEmpty()) {
                this.displaysBeingExecuted.remove();
            }
        }
        MetaDataBlock metadata = new MetaDataBlock(result.getChildren(), result.getMetaData());
        String source = (String)this.defaultEntityReferenceSerializer.serialize(includedReference, new Object[0]);
        metadata.getMetaData().addMetaData("source", (Object)source);
        metadata.getMetaData().addMetaData("base", (Object)source);
        return Collections.singletonList(metadata);
    }

    private void checkRecursiveDisplay(EntityReference reference) throws MacroExecutionException {
        Stack<Object> references = this.displaysBeingExecuted.get();
        if (references != null && references.contains(reference)) {
            throw new MacroExecutionException("Found recursive display of document [" + reference + "]");
        }
    }

    private EntityReference resolve(MacroBlock block, DisplayMacroParameters parameters) throws MacroExecutionException {
        String reference = parameters.getReference();
        if (reference == null) {
            throw new MacroExecutionException("You must specify a 'reference' parameter pointing to the entity to include.");
        }
        return this.macroEntityReferenceResolver.resolve((Object)reference, parameters.getType(), new Object[]{block});
    }
}

