/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.display;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MetadataBlockMatcher;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.display.DisplayMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="display")
@Singleton
public class DisplayMacro
extends AbstractMacro<DisplayMacroParameters> {
    private static final String DESCRIPTION = "Display other pages into the current page.";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    @Named(value="configured")
    private DocumentDisplayer documentDisplayer;

    public DisplayMacro() {
        super("Display", DESCRIPTION, DisplayMacroParameters.class);
        this.setPriority(10);
        this.setDefaultCategory("Content");
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public void setDocumentAccessBridge(DocumentAccessBridge documentAccessBridge) {
        this.documentAccessBridge = documentAccessBridge;
    }

    public List<Block> execute(DisplayMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        XDOM result;
        DocumentModelBridge documentBridge;
        if (parameters.getReference() == null) {
            throw new MacroExecutionException("You must specify a 'reference' parameter pointing to the entity to display.");
        }
        DocumentReference includedReference = this.resolve((Block)context.getCurrentMacroBlock(), parameters.getReference());
        this.checkRecursiveDisplayOrInclude((Block)context.getCurrentMacroBlock(), includedReference);
        if (!this.documentAccessBridge.isDocumentViewable(includedReference)) {
            throw new MacroExecutionException("Current user [" + this.documentAccessBridge.getCurrentUser() + "] doesn't have view rights on document [" + (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)includedReference, new Object[0]) + "]");
        }
        try {
            documentBridge = this.documentAccessBridge.getDocument(includedReference);
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to load Document [" + (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)includedReference, new Object[0]) + "]", (Throwable)e);
        }
        DocumentDisplayerParameters displayParameters = new DocumentDisplayerParameters();
        displayParameters.setContentTransformed(true);
        displayParameters.setExecutionContextIsolated(displayParameters.isContentTransformed());
        displayParameters.setSectionId(parameters.getSection());
        displayParameters.setTransformationContextIsolated(displayParameters.isContentTransformed());
        try {
            result = this.documentDisplayer.display((Object)documentBridge, (Object)displayParameters);
        }
        catch (Exception e) {
            throw new MacroExecutionException(e.getMessage(), (Throwable)e);
        }
        MetaDataBlock metadata = new MetaDataBlock(result.getChildren(), result.getMetaData());
        String source = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)includedReference, new Object[0]);
        metadata.getMetaData().addMetaData("source", (Object)source);
        metadata.getMetaData().addMetaData("base", (Object)source);
        return Arrays.asList(metadata);
    }

    private void checkRecursiveDisplayOrInclude(Block currrentBlock, DocumentReference documentReference) throws MacroExecutionException {
        Block parentBlock = currrentBlock.getParent();
        if (parentBlock != null) {
            MacroMarkerBlock parentMacro;
            if (parentBlock instanceof MacroMarkerBlock && this.isRecursive(parentMacro = (MacroMarkerBlock)parentBlock, documentReference)) {
                throw new MacroExecutionException("Found recursive inclusion of document [" + documentReference + "]");
            }
            this.checkRecursiveDisplayOrInclude(parentBlock, documentReference);
        }
    }

    private boolean isRecursive(MacroMarkerBlock parentMacro, DocumentReference documentReference) {
        if (parentMacro.getId().equals("display")) {
            return documentReference.equals((Object)this.resolve((Block)parentMacro, parentMacro.getParameter("reference")));
        }
        return false;
    }

    private DocumentReference resolve(Block block, String documentName) {
        DocumentReference result;
        MetaDataBlock metaDataBlock = (MetaDataBlock)block.getFirstBlock((BlockMatcher)new MetadataBlockMatcher("base"), Block.Axes.ANCESTOR);
        if (metaDataBlock == null) {
            result = this.currentDocumentReferenceResolver.resolve((Object)documentName, new Object[0]);
        } else {
            String sourceMetaData = (String)metaDataBlock.getMetaData().getMetaData("base");
            result = this.currentDocumentReferenceResolver.resolve((Object)documentName, new Object[]{this.currentDocumentReferenceResolver.resolve((Object)sourceMetaData, new Object[0])});
        }
        return result;
    }
}

