/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.display.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.display.internal.DocumentTitleDisplayer;
import org.xwiki.rendering.block.XDOM;

@Component
@Named(value="title/xwiki/1.0")
@Singleton
public class XWiki10DocumentTitleDisplayer
extends DocumentTitleDisplayer {
    private static final Pattern HEADING_PATTERN_10 = Pattern.compile("^\\s*+1(?:\\.1)?\\s++(.++)$", 8);

    @Override
    protected XDOM extractTitleFromContent(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        String title = "";
        Matcher matcher = HEADING_PATTERN_10.matcher(document.getContent());
        if (matcher.find()) {
            title = matcher.group(1).trim();
        }
        if (!title.isEmpty()) {
            return this.parseXDOM(this.evaluateTitle(title, document.getDocumentReference(), parameters));
        }
        return null;
    }
}

