/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.display.internal;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.context.Execution;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.display.internal.DocumentDisplayerParameters;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.util.ParserUtils;
import org.xwiki.velocity.VelocityManager;

public abstract class AbstractDocumentTitleDisplayer
implements DocumentDisplayer {
    private static final String EXTRACT_TITLE_STACK_TRACE_KEY = "internal.extractTitleFromContentStackTrace";
    @Inject
    private Logger logger;
    @Inject
    @Named(value="html/4.01")
    private Parser htmlParser;
    @Inject
    private VelocityManager velocityManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    private Execution execution;
    private ParserUtils parserUtils = new ParserUtils();

    @Override
    public XDOM display(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        String reference;
        if (!StringUtils.isEmpty((CharSequence)document.getTitle())) {
            try {
                return this.parseXDOM(this.evaluateTitle(document.getTitle(), document.getDocumentReference(), parameters));
            }
            catch (Exception e) {
                reference = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)document.getDocumentReference(), new Object[0]);
                this.logger.warn("Failed to interpret title of document [{}].", (Object)reference);
            }
        }
        try {
            XDOM title = this.safeExtractTitleFromContent(document, parameters);
            if (title != null) {
                return title;
            }
        }
        catch (Exception e) {
            reference = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)document.getDocumentReference(), new Object[0]);
            this.logger.warn("Failed to extract title from content of document [{}].", (Object)reference);
        }
        return this.parseXDOM(document.getDocumentReference().getName());
    }

    protected XDOM parseXDOM(String title) {
        try {
            XDOM xdom = this.htmlParser.parse((Reader)new StringReader(title));
            this.parserUtils.removeTopLevelParagraph(xdom.getChildren());
            return xdom;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    protected String evaluateTitle(String title, DocumentReference documentReference, DocumentDisplayerParameters parameters) {
        StringWriter writer = new StringWriter();
        String nameSpace = (String)this.defaultEntityReferenceSerializer.serialize((EntityReference)(parameters.isTransformationContextIsolated() ? documentReference : this.documentAccessBridge.getCurrentDocumentReference()), new Object[0]);
        HashMap backupObjects = null;
        try {
            if (parameters.isExecutionContextIsolated()) {
                backupObjects = new HashMap();
                this.documentAccessBridge.pushDocumentInContext(backupObjects, documentReference);
            }
            this.velocityManager.getVelocityEngine().evaluate((Context)this.velocityManager.getVelocityContext(), (Writer)writer, nameSpace, title);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (parameters.isExecutionContextIsolated()) {
                this.documentAccessBridge.popDocumentFromContext(backupObjects);
            }
        }
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XDOM safeExtractTitleFromContent(DocumentModelBridge document, DocumentDisplayerParameters parameters) {
        Map<Object, Object> xwikiContext = this.getXWikiContextMap();
        Stack<DocumentReference> stackTrace = (Stack<DocumentReference>)xwikiContext.get(EXTRACT_TITLE_STACK_TRACE_KEY);
        if (stackTrace == null) {
            stackTrace = new Stack<DocumentReference>();
            xwikiContext.put(EXTRACT_TITLE_STACK_TRACE_KEY, stackTrace);
        } else if (stackTrace.contains(document.getDocumentReference())) {
            return null;
        }
        stackTrace.push(document.getDocumentReference());
        try {
            XDOM xDOM = this.extractTitleFromContent(document, parameters);
            return xDOM;
        }
        finally {
            stackTrace.pop();
        }
    }

    private Map<Object, Object> getXWikiContextMap() {
        return (Map)this.execution.getContext().getProperty("xwikicontext");
    }

    protected abstract XDOM extractTitleFromContent(DocumentModelBridge var1, DocumentDisplayerParameters var2);

    protected Logger getLogger() {
        return this.logger;
    }
}

