/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.edit.script;

import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.edit.EditException;
import org.xwiki.edit.Editor;
import org.xwiki.edit.script.AbstractTypedEditScriptService;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxContent;
import org.xwiki.stability.Unstable;

@Component
@Singleton
@Named(value="edit.syntaxContent")
@Unstable
public class SyntaxContentEditScriptService
extends AbstractTypedEditScriptService<SyntaxContent> {
    public Editor<SyntaxContent> getDefaultTextEditor() {
        return this.getDefaultEditor("text");
    }

    public Editor<SyntaxContent> getDefaultWysiwygEditor() {
        return this.getDefaultEditor("wysiwyg");
    }

    public String text(String content, Syntax syntax, Map<String, Object> parameters) throws EditException {
        Editor<SyntaxContent> editor = this.getDefaultTextEditor();
        return editor == null ? null : editor.render(new SyntaxContent(content, syntax), parameters);
    }

    public String wysiwyg(String content, Syntax syntax, Map<String, Object> parameters) throws EditException {
        Editor<SyntaxContent> editor = this.getDefaultWysiwygEditor();
        return editor == null ? null : editor.render(new SyntaxContent(content, syntax), parameters);
    }
}

