/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.edit;

import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.edit.EditorDescriptor;
import org.xwiki.edit.internal.DefaultEditorDescriptor;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.stability.Unstable;

@Component(roles={EditorDescriptorBuilder.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
@Unstable
public class EditorDescriptorBuilder
implements EditorDescriptor {
    private String id;
    private String name;
    private String description;
    private String icon;
    private String category;
    @Inject
    private ContextualLocalizationManager localization;

    public EditorDescriptorBuilder setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public EditorDescriptorBuilder setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public EditorDescriptorBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public EditorDescriptorBuilder setIcon(String icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    public EditorDescriptorBuilder setCategory(String category) {
        this.category = category;
        return this;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public EditorDescriptor build() {
        if (StringUtils.isEmpty((CharSequence)this.id)) {
            throw new RuntimeException("The editor id is mandatory.");
        }
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            this.name = this.localization.getTranslationPlain(String.format("edit.editor.%s.name", this.id), new Object[0]);
            if (StringUtils.isEmpty((CharSequence)this.name)) {
                this.name = this.id;
            }
        }
        if (this.description == null) {
            this.description = this.localization.getTranslationPlain(String.format("edit.editor.%s.description", this.id), new Object[0]);
        }
        return new DefaultEditorDescriptor(this.id, this.name, this.description, this.icon, this.category);
    }
}

