/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.internal;

import java.util.Date;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventFactory;
import org.xwiki.eventstream.internal.DefaultEvent;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReferenceResolver;

@Component
@Singleton
public class DefaultEventFactory
implements EventFactory {
    private static final String EVENT_GROUP_ID = Event.class.getCanonicalName().concat("_groupId");
    @Inject
    private Execution execution;
    @Inject
    private EntityReferenceResolver<String> resolver;
    @Inject
    private DocumentAccessBridge bridge;

    @Override
    public Event createEvent() {
        DefaultEvent result = new DefaultEvent();
        result.setId(UUID.randomUUID().toString());
        result.setGroupId(this.getCurrentGroupId());
        result.setUser(new DocumentReference(this.resolver.resolve((Object)this.bridge.getCurrentUser(), EntityType.DOCUMENT, new Object[0])));
        result.setDate(new Date());
        return result;
    }

    @Override
    public Event createRawEvent() {
        return new DefaultEvent();
    }

    private String getCurrentGroupId() {
        String currentGroup = (String)this.execution.getContext().getProperty(EVENT_GROUP_ID);
        if (currentGroup == null) {
            currentGroup = UUID.randomUUID().toString();
            this.execution.getContext().setProperty(EVENT_GROUP_ID, (Object)currentGroup);
        }
        return currentGroup;
    }
}

