/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.eventstream.query;

import org.xwiki.eventstream.EventQuery;
import org.xwiki.stability.Unstable;

/**
 * Allow paging events.
 * 
 * @version $Id: 164cf0df0bf65368d53dcf9500d245fe063f7fd5 $
 * @since 12.4RC1
 */
@Unstable
public interface PageableEventQuery extends EventQuery
{
    /**
     * @return the maximum number of events to return
     */
    long getLimit();

    /**
     * @return the index where to start returning events
     */
    long getOffset();
}
