/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.eventstream;

import org.xwiki.stability.Unstable;

/**
 * This interface represents an event that is not identified by a specific class, but by its component hint. The event
 * can then be retrieved through the ComponentManager.
 *
 * @version $Id: fc54aff47c234cb9fff95d119308b9f1589b4be4 $
 * @since 9.6RC1
 */
@Unstable
public interface UntypedRecordableEvent extends RecordableEvent
{
    /**
     * Get the event type (the hint) of the current event.
     *
     * @return the event type
     */
    String getEventType();
}
