/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.internal.multi.ComponentManagerManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.RecordableEventDescriptor;
import org.xwiki.eventstream.RecordableEventDescriptorManager;
import org.xwiki.eventstream.UntypedRecordableEventDescriptor;
import org.xwiki.model.namespace.WikiNamespace;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Singleton
public class DefaultRecordableEventDescriptorManager
implements RecordableEventDescriptorManager {
    @Inject
    @Named(value="context")
    private ComponentManager contextComponentManager;
    @Inject
    private ComponentManagerManager componentManagerManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    @Override
    public List<RecordableEventDescriptor> getRecordableEventDescriptors(boolean allWikis) throws EventStreamException {
        try {
            HashSet<RecordableEventDescriptor> recordableEventDescriptors = new HashSet<RecordableEventDescriptor>();
            recordableEventDescriptors.addAll(this.contextComponentManager.getInstanceList(RecordableEventDescriptor.class));
            if (allWikis) {
                for (String wikiId : this.wikiDescriptorManager.getAllIds()) {
                    recordableEventDescriptors.addAll(this.getDescriptorsFromWiki(wikiId));
                }
            }
            return new ArrayList<RecordableEventDescriptor>(recordableEventDescriptors);
        }
        catch (ComponentLookupException | WikiManagerException e) {
            throw new EventStreamException("Failed to get the list of all Recordable Event Descriptors.", e);
        }
    }

    private List<RecordableEventDescriptor> getDescriptorsFromWiki(String wikiId) throws ComponentLookupException {
        WikiNamespace namespace = new WikiNamespace(wikiId);
        ComponentManager wikiComponentManager = this.componentManagerManager.getComponentManager(namespace.serialize(), false);
        if (wikiComponentManager == null) {
            return Collections.emptyList();
        }
        ArrayList<RecordableEventDescriptor> descriptors = new ArrayList<RecordableEventDescriptor>();
        descriptors.addAll(wikiComponentManager.getInstanceList(RecordableEventDescriptor.class));
        descriptors.addAll(wikiComponentManager.getInstanceList(UntypedRecordableEventDescriptor.class));
        return descriptors;
    }
}

