/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.eventstream.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.internal.ModelBridge;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;

@Component
@Singleton
public class DefaultModelBridge
implements ModelBridge {
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;

    public DocumentReference getAuthorReference(EntityReference entityReference) throws EventStreamException {
        return this.findDocument(entityReference).getAuthorReference();
    }

    public boolean checkXObjectPresence(List<String> xObjectTypes, Object source) {
        if (xObjectTypes.isEmpty()) {
            return true;
        }
        if (source instanceof XWikiDocument) {
            XWikiDocument document = (XWikiDocument)source;
            Map documentXObjects = document.getXObjects();
            for (String objectType : xObjectTypes) {
                LocalDocumentReference localXObjectReference = this.documentReferenceResolver.resolve((Object)objectType, new Object[0]).getLocalDocumentReference();
                for (DocumentReference documentReference : documentXObjects.keySet()) {
                    if (!documentReference.getLocalDocumentReference().equals((Object)localXObjectReference)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private XWikiDocument findDocument(EntityReference entityReference) throws EventStreamException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWiki xwiki = context.getWiki();
        try {
            return xwiki.getDocument(entityReference, context);
        }
        catch (XWikiException e) {
            throw new EventStreamException(String.format("Unable to retrieve the given document [%s] in the current context.", entityReference), (Throwable)e);
        }
    }
}

