/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.internal.validator;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.EnumUtils;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.component.namespace.NamespaceUtils;
import org.xwiki.extension.Extension;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.ExtensionValidator;
import org.xwiki.job.Request;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

public abstract class AbstractExtensionValidator
implements ExtensionValidator {
    public static final String PROPERTY_USERREFERENCE = "user.reference";
    public static final String PROPERTY_CALLERREFERENCE = "caller.reference";
    public static final String PROPERTY_CHECKRIGHTS = "checkrights";
    public static final String PROPERTY_CHECKRIGHTS_USER = "checkUserRights";
    public static final String PROPERTY_CHECKRIGHTS_CALLER = "checkAuthorRights";
    @Inject
    protected AuthorizationManager authorization;
    @Inject
    @Named(value="relative")
    protected EntityReferenceResolver<String> resolver;
    protected Right entityRight = Right.PROGRAM;

    public static DocumentReference getRequestUserReference(String property, Request request) {
        Object obj = request.getProperty(property);
        if (obj instanceof DocumentReference) {
            return (DocumentReference)obj;
        }
        return null;
    }

    protected void checkAccess(EntityReference entityReference, Right right, Request request) throws AccessDeniedException {
        this.checkAccess(PROPERTY_CHECKRIGHTS_CALLER, PROPERTY_CALLERREFERENCE, entityReference, right, request);
        this.checkAccess(PROPERTY_CHECKRIGHTS_USER, PROPERTY_USERREFERENCE, entityReference, right, request);
    }

    private void checkAccess(String propertySetReference, String propertyReference, EntityReference entityReference, Right right, Request request) throws AccessDeniedException {
        DocumentReference userReference = AbstractExtensionValidator.getRequestUserReference(propertyReference, request);
        if (userReference != null || request.getProperty(propertySetReference) == Boolean.TRUE) {
            this.authorization.checkAccess(right, userReference, entityReference);
        }
    }

    public void checkInstall(Extension extension, String namespace, Request request) throws InstallException {
        if (request.getProperty(PROPERTY_CHECKRIGHTS) == Boolean.TRUE) {
            this.checkInstallInternal(extension, namespace, request);
        }
    }

    protected void checkAccess(Extension extension, String namespaceString, Request request) throws AccessDeniedException {
        this.checkAccess(this.entityRight, namespaceString, request);
    }

    protected void checkAccess(Right entityRight, String namespaceString, Request request) throws AccessDeniedException {
        Namespace namespace = NamespaceUtils.toNamespace((String)namespaceString);
        if (namespace == null) {
            this.checkRootRight(entityRight, request);
            return;
        }
        if (namespace.getType() != null) {
            if (namespace.getType().equals("user")) {
                EntityReference reference = this.resolver.resolve((Object)namespace.getValue(), EntityType.DOCUMENT, new Object[0]);
                this.checkUserRight(reference, request);
                return;
            }
            EntityType entityType = (EntityType)EnumUtils.getEnum(EntityType.class, (String)namespace.getType().toUpperCase());
            if (entityType != null) {
                EntityReference reference = this.resolver.resolve((Object)namespace.getValue(), entityType, new Object[0]);
                this.checkAccess(reference, entityRight, request);
                return;
            }
        }
        this.checkNamespaceRight(namespace, Right.PROGRAM, request);
    }

    protected void checkInstallInternal(Extension extension, String namespace, Request request) throws InstallException {
        try {
            this.checkAccess(extension, namespace, request);
        }
        catch (AccessDeniedException e) {
            throw new InstallException(String.format("Install of extension [%s] is not allowed", extension.getId()), (Throwable)e);
        }
    }

    private void checkRootRight(Right entityRight, Request request) throws AccessDeniedException {
        this.checkAccess(null, entityRight, request);
    }

    private void checkUserRight(EntityReference entityReference, Request request) throws AccessDeniedException {
        this.checkUserAccess(PROPERTY_CHECKRIGHTS_CALLER, PROPERTY_CALLERREFERENCE, entityReference, request);
        this.checkUserAccess(PROPERTY_CHECKRIGHTS_USER, PROPERTY_USERREFERENCE, entityReference, request);
    }

    private void checkUserAccess(String propertySetReference, String propertyReference, EntityReference entityReference, Request request) throws AccessDeniedException {
        DocumentReference currentAuthorReference;
        DocumentReference userReference = AbstractExtensionValidator.getRequestUserReference(propertyReference, request);
        if (!(userReference == null && request.getProperty(propertySetReference) != Boolean.TRUE || (currentAuthorReference = AbstractExtensionValidator.getRequestUserReference(propertyReference, request)) != null && currentAuthorReference.equals((Object)entityReference))) {
            this.authorization.checkAccess(Right.PROGRAM, userReference, null);
        }
    }

    private void checkNamespaceRight(Namespace namespace, Right program, Request request) throws AccessDeniedException {
        this.checkAccess(null, Right.PROGRAM, request);
    }

    public void checkUninstall(InstalledExtension extension, String namespace, Request request) throws UninstallException {
        if (request.getProperty(PROPERTY_CHECKRIGHTS) == Boolean.TRUE) {
            this.checkUninstallInternal(extension, namespace, request);
        }
    }

    protected void checkUninstallInternal(InstalledExtension extension, String namespace, Request request) throws UninstallException {
        try {
            this.checkAccess((Extension)extension, namespace, request);
        }
        catch (AccessDeniedException e) {
            throw new UninstallException(String.format("Uninstall of extension [%s] is not allowed", extension.getId()), (Throwable)e);
        }
    }
}

