/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionLicense;
import org.xwiki.extension.repository.ExtensionRepository;

public abstract class AbstractExtension
implements Extension {
    protected ExtensionId id;
    protected Set<String> features = new HashSet<String>();
    protected String type;
    protected String name;
    protected List<ExtensionLicense> licenses = new ArrayList<ExtensionLicense>();
    protected String summary;
    protected String description;
    protected List<String> authors = new ArrayList<String>();
    protected String website;
    protected ExtensionRepository repository;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected List<ExtensionDependency> dependencies;

    public AbstractExtension(ExtensionRepository repository, ExtensionId id, String type) {
        this.repository = repository;
        this.id = id;
        this.type = type;
    }

    public AbstractExtension(ExtensionRepository repository, Extension extension) {
        this(repository, extension.getId(), extension.getType());
        this.setFeatures(extension.getFeatures());
        this.setDescription(extension.getDescription());
        this.setAuthors(extension.getAuthors());
        this.setWebsite(extension.getWebSite());
        List<? extends ExtensionDependency> newDependencies = extension.getDependencies();
        if (!newDependencies.isEmpty()) {
            this.dependencies = new ArrayList<ExtensionDependency>(extension.getDependencies());
        }
    }

    @Override
    public ExtensionId getId() {
        return this.id;
    }

    protected void setId(ExtensionId id) {
        this.id = id;
    }

    @Override
    public Collection<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(Collection<String> features) {
        this.features = new LinkedHashSet<String>(features);
    }

    public void addFeature(String feature) {
        this.features.add(feature);
    }

    @Override
    public String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Collection<ExtensionLicense> getLicenses() {
        return this.licenses;
    }

    public void setLicense(Collection<ExtensionLicense> licenses) {
        this.licenses = new ArrayList<ExtensionLicense>(licenses);
    }

    public void addLicense(ExtensionLicense license) {
        this.licenses.add(license);
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(Collection<String> authors) {
        this.authors = new ArrayList<String>(authors);
    }

    public void addAuthor(String author) {
        this.authors.add(author);
    }

    @Override
    public String getWebSite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public void addDependency(ExtensionDependency dependency) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<ExtensionDependency>();
        }
        this.dependencies.add(dependency);
    }

    @Override
    public List<? extends ExtensionDependency> getDependencies() {
        return this.dependencies != null ? Collections.unmodifiableList(this.dependencies) : Collections.emptyList();
    }

    public void setDependencies(Collection<? extends ExtensionDependency> dependencies) {
        this.dependencies = new ArrayList<ExtensionDependency>(dependencies);
    }

    @Override
    public ExtensionRepository getRepository() {
        return this.repository;
    }

    protected void setRepository(ExtensionRepository repository) {
        this.repository = repository;
    }

    @Override
    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void putProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public <T> T getProperty(String key, T def) {
        return (T)(this.properties.containsKey(key) ? this.properties.get(key) : def);
    }

    public String toString() {
        return this.getId().toString();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Extension && this.getId().equals(((Extension)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

