/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.handler.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.ExtensionException;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.ExtensionHandler;
import org.xwiki.extension.handler.ExtensionHandlerManager;

@Component
@Singleton
public class DefaultExtensionHandlerManager
implements ExtensionHandlerManager {
    private static final String LOOKUPERROR = "Can't find any extension handler for the extension ";
    @Inject
    private ComponentManager componentManager;

    private ExtensionHandler getExtensionHandler(LocalExtension localExtension) throws ComponentLookupException {
        return (ExtensionHandler)this.componentManager.lookup(ExtensionHandler.class, localExtension.getType().toLowerCase());
    }

    @Override
    public void install(LocalExtension localExtension, String namespace) throws InstallException {
        ExtensionHandler extensionHandler;
        try {
            extensionHandler = this.getExtensionHandler(localExtension);
        }
        catch (ComponentLookupException e) {
            throw new InstallException("Can't find any extension handler for the extension [" + localExtension + ']', e);
        }
        try {
            extensionHandler.install(localExtension, namespace);
        }
        catch (Exception e) {
            throw new InstallException("Failed to install extension [" + localExtension.getId() + "]", e);
        }
    }

    @Override
    public void uninstall(LocalExtension localExtension, String namespace) throws UninstallException {
        try {
            ExtensionHandler extensionHandler = this.getExtensionHandler(localExtension);
            extensionHandler.uninstall(localExtension, namespace);
        }
        catch (ComponentLookupException e) {
            throw new UninstallException("Can't find any extension handler for the extension [" + localExtension + ']');
        }
    }

    @Override
    public void upgrade(LocalExtension previousLocalExtension, LocalExtension newLocalExtension, String namespace) throws InstallException {
        try {
            ExtensionHandler extensionHandler = this.getExtensionHandler(previousLocalExtension);
            extensionHandler.upgrade(previousLocalExtension, newLocalExtension, namespace);
        }
        catch (ComponentLookupException e) {
            throw new InstallException("Can't find any extension handler for the extension [" + newLocalExtension + ']');
        }
    }

    @Override
    public void initialize(LocalExtension localExtension, String namespace) throws ExtensionException {
        try {
            ExtensionHandler extensionHandler = this.getExtensionHandler(localExtension);
            extensionHandler.initialize(localExtension, namespace);
        }
        catch (Exception e) {
            throw new InstallException("Failed to initialize extension [" + localExtension.getId() + "]", e);
        }
    }
}

