/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.test;

import java.util.List;
import org.junit.Before;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.Job;
import org.xwiki.extension.job.JobManager;
import org.xwiki.extension.job.Request;
import org.xwiki.extension.job.UninstallRequest;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.internal.DefaultExtensionPlan;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.test.ConfigurableDefaultCoreExtensionRepository;
import org.xwiki.extension.test.RepositoryUtil;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.test.AbstractComponentTestCase;

public abstract class AbstractExtensionHandlerTest
extends AbstractComponentTestCase {
    protected LocalExtensionRepository localExtensionRepository;
    protected RepositoryUtil repositoryUtil;
    protected JobManager jobManager;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.beforeRepositoryUtil();
        this.repositoryUtil = new RepositoryUtil(this.getConfigurationSource(), (ComponentManager)this.getComponentManager());
        this.repositoryUtil.setup(this.getMockery());
        this.jobManager = (JobManager)this.getComponentManager().lookup(JobManager.class);
        this.localExtensionRepository = (LocalExtensionRepository)this.getComponentManager().lookup(LocalExtensionRepository.class);
    }

    protected void beforeRepositoryUtil() throws Exception {
    }

    protected void registerComponents() throws Exception {
        super.registerComponents();
        this.registerComponent(ConfigurableDefaultCoreExtensionRepository.class);
    }

    protected Job executeJob(String jobId, Request request) throws Throwable {
        Job installJob = this.jobManager.executeJob(jobId, request);
        List errors = installJob.getStatus().getLog(LogLevel.ERROR);
        if (!errors.isEmpty()) {
            throw ((LogEvent)errors.get(0)).getThrowable();
        }
        return installJob;
    }

    protected LocalExtension install(ExtensionId extensionId, String namespace) throws Throwable {
        this.install("install", extensionId, namespace);
        return (LocalExtension)this.localExtensionRepository.resolve(extensionId);
    }

    protected ExtensionPlan installPlan(ExtensionId extensionId, String namespace) throws Throwable {
        Job installJob = this.install("installplan", extensionId, namespace);
        return (ExtensionPlan)installJob.getStatus();
    }

    protected Job install(String jobId, ExtensionId extensionId, String namespace) throws Throwable {
        InstallRequest installRequest = new InstallRequest();
        installRequest.addExtension(extensionId);
        if (namespace != null) {
            installRequest.addNamespace(namespace);
        }
        return this.executeJob(jobId, (Request)installRequest);
    }

    protected LocalExtension uninstall(ExtensionId extensionId, String namespace) throws Throwable {
        this.uninstall("uninstall", extensionId, namespace);
        return (LocalExtension)this.localExtensionRepository.resolve(extensionId);
    }

    protected DefaultExtensionPlan<UninstallRequest> uninstallPlan(ExtensionId extensionId, String namespace) throws Throwable {
        Job uninstallJob = this.uninstall("installplan", extensionId, namespace);
        return (DefaultExtensionPlan)uninstallJob.getStatus();
    }

    protected Job uninstall(String jobId, ExtensionId extensionId, String namespace) throws Throwable {
        UninstallRequest uninstallRequest = new UninstallRequest();
        uninstallRequest.addExtension(extensionId);
        if (namespace != null) {
            uninstallRequest.addNamespace(namespace);
        }
        return this.executeJob(jobId, (Request)uninstallRequest);
    }
}

