/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.xwiki.extension.job.event.status.JobProgress;
import org.xwiki.extension.job.event.status.PopLevelProgressEvent;
import org.xwiki.extension.job.event.status.PushLevelProgressEvent;
import org.xwiki.extension.job.event.status.StepProgressEvent;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

public class DefaultJobProgress
implements EventListener,
JobProgress {
    private static final List<Event> EVENTS = Arrays.asList(new PushLevelProgressEvent(), new PopLevelProgressEvent(), new StepProgressEvent());
    private String name;
    private Stack<Level> progress = new Stack();

    public DefaultJobProgress(String id) {
        this.name = this.getClass().getName() + '_' + id;
    }

    public String getName() {
        return this.name;
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void onEvent(Event event, Object arg1, Object arg2) {
        if (event instanceof PushLevelProgressEvent) {
            PushLevelProgressEvent progressEvent = (PushLevelProgressEvent)event;
            if (this.progress.isEmpty()) {
                this.progress.push(new Level(progressEvent.getSteps(), this.getOffset(), 1.0));
            } else {
                this.progress.push(new Level(progressEvent.getSteps(), this.getOffset(), this.progress.peek().globalStepSize));
            }
        } else if (event instanceof PopLevelProgressEvent) {
            this.progress.pop();
            this.nextStep();
        } else if (event instanceof StepProgressEvent) {
            this.nextStep();
        }
    }

    private void nextStep() {
        if (!this.progress.isEmpty()) {
            Level step = this.progress.peek();
            ++step.currentStep;
            step.globalOffset += step.globalStepSize;
            step.levelOffset += step.localStepSize;
        }
    }

    @Override
    public double getOffset() {
        return this.progress.isEmpty() ? 0.0 : this.progress.peek().globalOffset;
    }

    @Override
    public double getCurrentLevelOffset() {
        return this.progress.isEmpty() ? 0.0 : this.progress.peek().levelOffset;
    }

    static class Level {
        public double globalOffset;
        public double levelOffset;
        public double globalStepSize;
        public double localStepSize;
        public int currentStep;
        public int steps;

        public Level(int steps, double offset, double parentSize) {
            this.steps = steps;
            this.globalOffset = offset;
            this.globalStepSize = parentSize / (double)steps;
            this.levelOffset = 0.0;
            this.localStepSize = 1.0 / (double)steps;
        }
    }
}

