/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.job.internal;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.Extension;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.event.ExtensionUpgradedEvent;
import org.xwiki.extension.handler.ExtensionHandlerManager;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.Job;
import org.xwiki.extension.job.Request;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepositoryException;
import org.xwiki.logging.LogLevel;
import org.xwiki.logging.event.LogEvent;
import org.xwiki.observation.event.Event;

@Component
@Named(value="install")
public class InstallJob
extends AbstractExtensionJob<InstallRequest> {
    public static final String JOBTYPE = "install";
    @Inject
    private LocalExtensionRepository localExtensionRepository;
    @Inject
    private ExtensionHandlerManager extensionHandlerManager;
    @Inject
    @Named(value="installplan")
    private Job installPlanJob;

    @Override
    public String getType() {
        return JOBTYPE;
    }

    @Override
    protected InstallRequest castRequest(Request request) {
        InstallRequest installRequest = request instanceof InstallRequest ? (InstallRequest)request : new InstallRequest(request);
        return installRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void start() throws Exception {
        this.notifyPushLevelProgress(3);
        try {
            this.installPlanJob.start((Request)this.getRequest());
            ExtensionPlan plan = (ExtensionPlan)this.installPlanJob.getStatus();
            List<LogEvent> log = plan.getLog(LogLevel.ERROR);
            if (!log.isEmpty()) {
                throw new InstallException("Failed to create install plan: " + log.get(0).getFormattedMessage(), log.get(0).getThrowable());
            }
            this.notifyStepPropress();
            Collection<ExtensionPlanAction> actions = plan.getActions();
            this.notifyPushLevelProgress(actions.size());
            try {
                for (ExtensionPlanAction action : actions) {
                    this.store(action);
                    this.notifyStepPropress();
                }
            }
            finally {
                this.notifyPopLevelProgress();
            }
            this.notifyStepPropress();
            this.notifyPushLevelProgress(actions.size());
            try {
                for (ExtensionPlanAction action : actions) {
                    if (action.getAction() != ExtensionPlanAction.Action.NONE) {
                        this.applyAction(action);
                    }
                    this.notifyStepPropress();
                }
            }
            finally {
                this.notifyPopLevelProgress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    private void store(ExtensionPlanAction action) throws LocalExtensionRepositoryException, InstallException {
        if (action.getAction() == ExtensionPlanAction.Action.INSTALL || action.getAction() == ExtensionPlanAction.Action.UPGRADE) {
            this.storeExtension(action.getExtension());
        }
    }

    private void storeExtension(Extension extension) throws LocalExtensionRepositoryException {
        if (!(extension instanceof LocalExtension)) {
            this.localExtensionRepository.storeExtension(extension);
        }
    }

    private void installExtension(LocalExtension extension, LocalExtension previousExtension, String namespace, boolean dependency) throws InstallException {
        if (previousExtension == null) {
            this.extensionHandlerManager.install(extension, namespace, this.getExtraHandlerParameters());
            this.localExtensionRepository.installExtension(extension, namespace, dependency);
            this.observationManager.notify((Event)new ExtensionInstalledEvent(extension.getId(), namespace), (Object)extension);
        } else {
            this.extensionHandlerManager.upgrade(previousExtension, extension, namespace, this.getExtraHandlerParameters());
            try {
                this.localExtensionRepository.uninstallExtension(previousExtension, namespace);
            }
            catch (UninstallException e) {
                this.logger.error("Failed to uninstall extension [" + previousExtension + "]", (Throwable)e);
            }
            this.localExtensionRepository.installExtension(extension, namespace, dependency);
            this.observationManager.notify((Event)new ExtensionUpgradedEvent(extension.getId(), namespace), (Object)extension, (Object)previousExtension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyAction(ExtensionPlanAction action) throws InstallException, LocalExtensionRepositoryException, ResolveException {
        if (action.getAction() != ExtensionPlanAction.Action.INSTALL && action.getAction() != ExtensionPlanAction.Action.UPGRADE) {
            throw new InstallException("Unsupported action [" + (Object)((Object)action.getAction()) + "]");
        }
        Extension extension = action.getExtension();
        String namespace = action.getNamespace();
        if (namespace != null) {
            this.logger.info("Installing extension [{}] on namespace [{}]", (Object)extension, (Object)namespace);
        } else {
            this.logger.info("Installing extension [{}]", (Object)extension);
        }
        this.notifyPushLevelProgress(2);
        try {
            LocalExtension localExtension = (LocalExtension)this.localExtensionRepository.resolve(extension.getId());
            this.notifyStepPropress();
            this.installExtension(localExtension, action.getPreviousExtension(), namespace, action.isDependency());
            if (namespace != null) {
                this.logger.info("Successfully installed extension [{}] on namespace [{}]", (Object)localExtension, (Object)namespace);
            } else {
                this.logger.info("Successfully installed extension [{}]", (Object)localExtension);
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }
}

