/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.unmodifiable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.CoreExtensionFile;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionFile;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.LocalExtensionFile;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.unmodifiable.UnmodifiableCoreExtension;
import org.xwiki.extension.unmodifiable.UnmodifiableCoreExtensionFile;
import org.xwiki.extension.unmodifiable.UnmodifiableCoreExtensionRepository;
import org.xwiki.extension.unmodifiable.UnmodifiableExtension;
import org.xwiki.extension.unmodifiable.UnmodifiableExtensionFile;
import org.xwiki.extension.unmodifiable.UnmodifiableExtensionRepository;
import org.xwiki.extension.unmodifiable.UnmodifiableLocalExtension;
import org.xwiki.extension.unmodifiable.UnmodifiableLocalExtensionFile;
import org.xwiki.extension.unmodifiable.UnmodifiableLocalExtensionRepository;
import org.xwiki.extension.wrap.WrappingExtension;

public final class UnmodifiableUtils {
    private UnmodifiableUtils() {
    }

    public static <K> Map<K, Collection<LocalExtension>> unmodifiableExtensions(Map<K, Collection<LocalExtension>> extensions) {
        LinkedHashMap wrappedExtensions = new LinkedHashMap();
        for (Map.Entry<K, Collection<LocalExtension>> entry : extensions.entrySet()) {
            wrappedExtensions.put(entry.getKey(), UnmodifiableUtils.unmodifiableExtensions(entry.getValue()));
        }
        return wrappedExtensions;
    }

    public static <T extends Extension, U extends T> Collection<T> unmodifiableExtensions(Collection<U> extensions) {
        ArrayList<T> wrappedExtensions = new ArrayList<T>(extensions.size());
        for (Extension extension : extensions) {
            T wrapper = UnmodifiableUtils.unmodifiableExtension(extension);
            if (wrapper == null) continue;
            wrappedExtensions.add(wrapper);
        }
        return wrappedExtensions;
    }

    public static <T extends Extension, U extends T> T unmodifiableExtension(U extension) {
        WrappingExtension wrappedExtension = extension == null ? null : (extension instanceof CoreExtension ? new UnmodifiableCoreExtension<CoreExtension>((CoreExtension)extension) : (extension instanceof LocalExtension ? new UnmodifiableLocalExtension<LocalExtension>((LocalExtension)extension) : new UnmodifiableExtension<U>(extension)));
        return (T)wrappedExtension;
    }

    public static <T extends ExtensionRepository, U extends T> T unmodifiableExtensionRepository(U repository) {
        UnmodifiableExtensionRepository wrappedExtensionRepository = repository == null ? null : (repository instanceof CoreExtensionRepository ? new UnmodifiableCoreExtensionRepository<CoreExtensionRepository>((CoreExtensionRepository)repository) : (repository instanceof LocalExtensionRepository ? new UnmodifiableLocalExtensionRepository<LocalExtensionRepository>((LocalExtensionRepository)repository) : new UnmodifiableExtensionRepository<U>(repository)));
        return (T)wrappedExtensionRepository;
    }

    public static <T extends ExtensionRepository, U extends T> Collection<T> unmodifiableExtensionRepositories(Collection<U> repositories) {
        ArrayList<T> wrappedRepositories = new ArrayList<T>(repositories.size());
        for (ExtensionRepository repository : repositories) {
            T wrapper = UnmodifiableUtils.unmodifiableExtensionRepository(repository);
            if (wrapper == null) continue;
            wrappedRepositories.add(wrapper);
        }
        return wrappedRepositories;
    }

    public static <T extends ExtensionFile, U extends T> T unmodifiableExtensionFile(U extensionFile) {
        UnmodifiableExtensionFile wrappedExtensionFile = extensionFile == null ? null : (extensionFile instanceof CoreExtension ? new UnmodifiableCoreExtensionFile<CoreExtensionFile>((CoreExtensionFile)extensionFile) : (extensionFile instanceof LocalExtension ? new UnmodifiableLocalExtensionFile<LocalExtensionFile>((LocalExtensionFile)extensionFile) : new UnmodifiableExtensionFile<U>(extensionFile)));
        return (T)wrappedExtensionFile;
    }
}

