/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal;

import com.google.common.base.Objects;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.plugin.rightsmanager.RightsManager;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.extension.CoreExtension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.extension.distribution.internal.job.DefaultDistributionJob;
import org.xwiki.extension.distribution.internal.job.DistributionJob;
import org.xwiki.extension.distribution.internal.job.DistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.DistributionRequest;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.job.Job;
import org.xwiki.job.JobStatusStore;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.logging.LoggerManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Singleton
public class DefaultDistributionManager
implements DistributionManager,
Initializable {
    private static final String JOBID = "distribution";
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private JobStatusStore jobStore;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private ExecutionContextManager executionContextManager;
    @Inject
    protected Provider<ObservationManager> observationManagerProvider;
    @Inject
    protected Provider<LoggerManager> loggerManagerProvider;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private JobStatusStore jobStatusStorage;
    @Inject
    private Logger logger;
    @Inject
    private ConfigurationSource configuration;
    private CoreExtension distributionExtension;
    private ExtensionId mainUIExtensionId;
    private ExtensionId wikiUIExtensionId;
    private DefaultDistributionJob farmDistributionJob;
    private Map<String, DistributionJob> wikiDistributionJobs = new ConcurrentHashMap<String, DistributionJob>();

    public void initialize() throws InitializationException {
        this.mainUIExtensionId = (ExtensionId)this.configuration.getProperty("distribution.defaultUI", ExtensionId.class);
        this.wikiUIExtensionId = (ExtensionId)this.configuration.getProperty("distribution.defaultWikiUI", ExtensionId.class);
        this.distributionExtension = this.coreExtensionRepository.getEnvironmentExtension();
        if (this.distributionExtension != null) {
            if (this.mainUIExtensionId == null) {
                String mainUIId = (String)this.distributionExtension.getProperty("xwiki.extension.distribution.ui");
                if (mainUIId != null) {
                    String mainUIVersion = (String)this.distributionExtension.getProperty("xwiki.extension.distribution.ui.version");
                    this.mainUIExtensionId = new ExtensionId(mainUIId, (Version)(mainUIVersion != null ? new DefaultVersion(mainUIVersion) : this.distributionExtension.getId().getVersion()));
                }
            } else if (this.mainUIExtensionId.getVersion() == null) {
                this.mainUIExtensionId = new ExtensionId(this.mainUIExtensionId.getId(), this.distributionExtension.getId().getVersion());
            }
            if (this.wikiUIExtensionId == null) {
                String wikiUIId = (String)this.distributionExtension.getProperty("xwiki.extension.distribution.wikiui");
                if (wikiUIId != null) {
                    String wikiUIVersion = (String)this.distributionExtension.getProperty("xwiki.extension.distribution.wikiui.version");
                    this.wikiUIExtensionId = new ExtensionId(wikiUIId, (Version)(wikiUIVersion != null ? new DefaultVersion(wikiUIVersion) : this.distributionExtension.getId().getVersion()));
                }
            } else if (this.wikiUIExtensionId.getVersion() == null) {
                this.wikiUIExtensionId = new ExtensionId(this.wikiUIExtensionId.getId(), this.distributionExtension.getId().getVersion());
            }
        }
    }

    private List<String> getFarmJobId() {
        return Arrays.asList(JOBID);
    }

    @Override
    public DefaultDistributionJob startFarmJob() {
        try {
            this.farmDistributionJob = (DefaultDistributionJob)this.componentManager.getInstance(Job.class, JOBID);
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            final DistributionRequest request = new DistributionRequest();
            request.setId(this.getFarmJobId());
            request.setWiki(xcontext.getMainXWiki());
            request.setUserReference(xcontext.getUserReference());
            request.setInteractive((Boolean)this.configuration.getProperty("distribution.job.interactive", (Object)true));
            Thread distributionJobThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ExecutionContext context = new ExecutionContext();
                    try {
                        DefaultDistributionManager.this.executionContextManager.initialize(context);
                    }
                    catch (ExecutionContextException e) {
                        throw new RuntimeException("Failed to initialize farm distribution job execution context", e);
                    }
                    DefaultDistributionManager.this.farmDistributionJob.initialize((Request)request);
                    DefaultDistributionManager.this.farmDistributionJob.run();
                }
            });
            distributionJobThread.setDaemon(true);
            distributionJobThread.setName("Farm distribution initialization");
            distributionJobThread.start();
            this.farmDistributionJob.awaitReady();
            return this.farmDistributionJob;
        }
        catch (Exception e) {
            this.logger.error("Failed to create farm distribution job", (Throwable)e);
            return null;
        }
    }

    private List<String> getWikiJobId(String wiki) {
        return Arrays.asList(JOBID, "wiki", wiki);
    }

    @Override
    public DistributionJob startWikiJob(String wiki) {
        try {
            DistributionJob wikiJob = (DistributionJob)this.componentManager.getInstance(Job.class, JOBID);
            this.wikiDistributionJobs.put(wiki, wikiJob);
            final DistributionRequest request = new DistributionRequest();
            request.setId(this.getWikiJobId(wiki));
            request.setWiki(wiki);
            request.setUserReference(((XWikiContext)this.xcontextProvider.get()).getUserReference());
            request.setInteractive((Boolean)this.configuration.getProperty("distribution.job.interactive.wiki", (Object)true));
            Thread distributionJobThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ExecutionContext context = new ExecutionContext();
                    try {
                        DefaultDistributionManager.this.executionContextManager.initialize(context);
                    }
                    catch (ExecutionContextException e) {
                        throw new RuntimeException("Failed to initialize wiki distribution job execution context", e);
                    }
                    DistributionJob job = (DistributionJob)DefaultDistributionManager.this.wikiDistributionJobs.get(request.getWiki());
                    job.initialize((Request)request);
                    job.run();
                }
            });
            distributionJobThread.setDaemon(true);
            distributionJobThread.setName("Distribution initialization of wiki [" + wiki + "]");
            distributionJobThread.start();
            wikiJob.awaitReady();
            return wikiJob;
        }
        catch (Exception e) {
            this.logger.error("Failed to create distribution job for wiki [" + wiki + "]", (Throwable)e);
            return null;
        }
    }

    private DistributionManager.DistributionState getDistributionState(DistributionJobStatus previousStatus) {
        return DistributionJobStatus.getDistributionState(previousStatus != null ? previousStatus.getDistributionExtension() : null, this.distributionExtension != null ? this.distributionExtension.getId() : null);
    }

    @Override
    public DistributionManager.DistributionState getFarmDistributionState() {
        DistributionJobStatus previousStatus = null;
        try {
            previousStatus = this.getPreviousFarmJobStatus();
        }
        catch (Exception e) {
            this.logger.error("Failed to load previous status", (Throwable)e);
        }
        return this.getDistributionState(previousStatus);
    }

    @Override
    public DistributionManager.DistributionState getWikiDistributionState(String wiki) {
        return this.getDistributionState(this.getPreviousWikiJobStatus(wiki));
    }

    @Override
    public CoreExtension getDistributionExtension() {
        return this.distributionExtension;
    }

    @Override
    public ExtensionId getMainUIExtensionId() {
        return this.mainUIExtensionId;
    }

    @Override
    public ExtensionId getWikiUIExtensionId() {
        return this.wikiUIExtensionId;
    }

    @Override
    public DistributionJobStatus getPreviousFarmJobStatus() {
        JobStatus jobStatus = this.jobStore.getJobStatus(this.getFarmJobId());
        DistributionJobStatus farmJobStatus = jobStatus != null ? (jobStatus instanceof DistributionJobStatus ? (DistributionJobStatus)jobStatus : new DistributionJobStatus(jobStatus, (ObservationManager)this.observationManagerProvider.get(), (LoggerManager)this.loggerManagerProvider.get())) : null;
        return farmJobStatus;
    }

    @Override
    public DistributionJobStatus getPreviousWikiJobStatus(String wiki) {
        return (DistributionJobStatus)this.jobStore.getJobStatus(this.getWikiJobId(wiki));
    }

    @Override
    public DefaultDistributionJob getFarmJob() {
        return this.farmDistributionJob;
    }

    @Override
    public DistributionJob getWikiJob(String wiki) {
        return this.wikiDistributionJobs.get(wiki);
    }

    @Override
    public DistributionJob getCurrentDistributionJob() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        return xcontext.isMainWiki() ? this.getFarmJob() : this.getWikiJob(xcontext.getWikiId());
    }

    @Override
    public boolean canDisplayDistributionWizard() {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        DocumentReference currentUser = xcontext.getUserReference();
        DistributionJob job = this.getCurrentDistributionJob();
        if (job != null && Objects.equal((Object)currentUser, (Object)job.getRequest().getUserReference())) {
            this.logger.debug("The user [{}] started the DW so he can access it", (Object)currentUser);
            return true;
        }
        if (currentUser != null) {
            return this.authorizationManager.hasAccess(Right.ADMIN, currentUser, (EntityReference)new WikiReference(xcontext.getWikiId()));
        }
        if (xcontext.isMainWiki()) {
            try {
                return RightsManager.getInstance().countAllGlobalUsersOrGroups(true, (Object[][])null, xcontext) == 0;
            }
            catch (XWikiException e) {
                this.logger.error("Failed to count global users", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public void deletePreviousWikiJobStatus(String wiki) {
        this.jobStatusStorage.remove(this.getWikiJobId(wiki));
        this.wikiDistributionJobs.remove(wiki);
    }

    @Override
    public void copyPreviousWikiJobStatus(String sourceWiki, String targetWiki) {
        DistributionJobStatus sourceStatus = this.getPreviousWikiJobStatus(sourceWiki);
        if (sourceStatus != null) {
            DistributionJobStatus targetStatus = new DistributionJobStatus((JobStatus)sourceStatus, (ObservationManager)this.observationManagerProvider.get(), (LoggerManager)this.loggerManagerProvider.get());
            DistributionRequest request = (DistributionRequest)targetStatus.getRequest();
            request.setId(this.getWikiJobId(targetWiki));
            request.setWiki(targetWiki);
            this.jobStatusStorage.store((JobStatus)targetStatus);
        }
    }
}

