/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.extension.Extension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.xar.internal.handler.XarExtensionPlan;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.job.JobContext;
import org.xwiki.job.Request;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="distribution.DocumentsModifiedDuringDistributionListener")
@Singleton
public class DocumentsModifiedDuringDistributionListener
extends AbstractEventListener {
    public static final String NAME = "distribution.DocumentsModifiedDuringDistributionListener";
    @Inject
    private Execution execution;
    @Inject
    private JobContext jobContext;
    private Map<String, Map<DocumentReference, DocumentStatus>> documents = new HashMap<String, Map<DocumentReference, DocumentStatus>>();

    public DocumentsModifiedDuringDistributionListener() {
        super("DocumentsModifiedDuringDistributionListener", new Event[]{new DocumentCreatedEvent(), new DocumentDeletedEvent(), new DocumentUpdatedEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        this.checkXARHandler(event, (XWikiDocument)source, (XWikiContext)data);
        this.checkDistributionAction(event, (XWikiDocument)source, (XWikiContext)data);
    }

    private static DocumentStatus.Action toAction(Event event) {
        DocumentStatus.Action action = event instanceof DocumentCreatedEvent ? DocumentStatus.Action.CREATED : (event instanceof DocumentDeletedEvent ? DocumentStatus.Action.DELETED : DocumentStatus.Action.MODIFIED);
        return action;
    }

    private void checkXARHandler(Event event, XWikiDocument document, XWikiContext xcontext) {
        String distributionWiki;
        Request request;
        XarExtensionPlan xarExtensionPlan;
        ExecutionContext context = this.execution.getContext();
        if (context != null && (xarExtensionPlan = (XarExtensionPlan)context.getProperty("extension.xar.installplan")) != null && StringUtils.equals((CharSequence)((CharSequence)(request = this.jobContext.getCurrentJob().getRequest()).getProperty("context.action")), (CharSequence)"distribution") && (distributionWiki = (String)request.getProperty("context.wiki")) != null) {
            DocumentReference reference = document.getDocumentReferenceWithLocale();
            DocumentStatus.Action action = DocumentsModifiedDuringDistributionListener.toAction(event);
            XarInstalledExtension previousExtension = xarExtensionPlan.getPreviousXarExtension(reference);
            LocalExtension nextExtension = xarExtensionPlan.getNextXarExtension(reference);
            this.addDocument(distributionWiki, document, action, (LocalExtension)previousExtension, nextExtension);
        }
    }

    private void checkDistributionAction(Event event, XWikiDocument document, XWikiContext xcontext) {
        if ("distribution".equals(xcontext.getAction())) {
            String distributionWiki = xcontext.getOriginalWikiId();
            DocumentStatus.Action action = DocumentsModifiedDuringDistributionListener.toAction(event);
            this.addDocument(distributionWiki, document, action, null, null);
        }
    }

    private void addDocument(String distributionWiki, XWikiDocument document, DocumentStatus.Action action, LocalExtension previousExtension, LocalExtension nextExtension) {
        String previousVersion;
        DocumentReference reference;
        DocumentStatus currentStatus;
        Map<DocumentReference, DocumentStatus> wikiDocuments = this.documents.get(distributionWiki);
        if (wikiDocuments == null) {
            wikiDocuments = new HashMap<DocumentReference, DocumentStatus>();
            this.documents.put(distributionWiki, wikiDocuments);
        }
        if ((currentStatus = wikiDocuments.get(reference = document.getDocumentReferenceWithLocale())) != null) {
            previousVersion = currentStatus.getPreviousVersion();
            if (action == DocumentStatus.Action.CREATED) {
                if (previousVersion != null) {
                    action = DocumentStatus.Action.MODIFIED;
                }
            } else if (action == DocumentStatus.Action.DELETED) {
                if (previousVersion == null) {
                    wikiDocuments.remove(reference);
                    return;
                }
            } else if (action == DocumentStatus.Action.MODIFIED) {
                action = currentStatus.getAction();
            }
        } else {
            previousVersion = action != DocumentStatus.Action.CREATED ? document.getOriginalDocument().getVersion() : null;
        }
        wikiDocuments.put(reference, new DocumentStatus(reference, previousVersion, action, (Extension)previousExtension, (Extension)nextExtension));
    }

    public Map<String, Map<DocumentReference, DocumentStatus>> getDocuments() {
        return this.documents;
    }

    public static class DocumentStatus {
        private final DocumentReference reference;
        private final String previousVersion;
        private final Action action;
        private final Extension previousExtension;
        private final Extension nextExtension;

        public DocumentStatus(DocumentReference reference, String version, Action action) {
            this(reference, version, action, null, null);
        }

        public DocumentStatus(DocumentReference reference, String previousVersion, Action action, Extension previousExtension, Extension nextExtension) {
            this.reference = reference;
            this.previousVersion = previousVersion;
            this.action = action;
            this.previousExtension = previousExtension;
            this.nextExtension = nextExtension;
        }

        public DocumentReference getReference() {
            return this.reference;
        }

        public String getPreviousVersion() {
            return this.previousVersion;
        }

        public Action getAction() {
            return this.action;
        }

        public Extension getNextExtension() {
            return this.nextExtension;
        }

        public Extension getPreviousExtension() {
            return this.previousExtension;
        }

        public static enum Action {
            CREATED,
            DELETED,
            MODIFIED;

        }
    }
}

