/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.distribution.internal.DistributionManager;
import org.xwiki.extension.distribution.internal.job.DistributionRequest;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;
import org.xwiki.job.DefaultJobStatus;
import org.xwiki.job.Request;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.logging.LoggerManager;
import org.xwiki.observation.ObservationManager;

public class DistributionJobStatus
extends DefaultJobStatus<DistributionRequest> {
    private static final long serialVersionUID = 2L;
    private ExtensionId previousDistributionExtension;
    private ExtensionId previousDistributionExtensionUi;
    private ExtensionId distributionExtension;
    private ExtensionId distributionExtensionUi;
    private List<DistributionStep> stepList;
    private int currentStateIndex;
    private final transient Map<String, Object> properties = new ConcurrentHashMap<String, Object>();

    public DistributionJobStatus(JobStatus status, ObservationManager observationManager, LoggerManager loggerManager) {
        super(status.getJobType(), (Request)ObjectUtils.cloneIfPossible((Object)((DistributionRequest)status.getRequest())), null, observationManager, loggerManager);
        if (status instanceof DistributionJobStatus) {
            DistributionJobStatus distributionJobStatus = (DistributionJobStatus)status;
            this.previousDistributionExtension = distributionJobStatus.previousDistributionExtension;
            this.previousDistributionExtensionUi = distributionJobStatus.previousDistributionExtensionUi;
            this.distributionExtension = distributionJobStatus.distributionExtension;
            this.distributionExtensionUi = distributionJobStatus.distributionExtensionUi;
            this.stepList = distributionJobStatus.stepList != null ? new ArrayList<DistributionStep>(distributionJobStatus.stepList) : new ArrayList();
        }
    }

    public DistributionJobStatus(DistributionRequest request, ObservationManager observationManager, LoggerManager loggerManager, List<DistributionStep> steps) {
        super("distribution", (Request)request, null, observationManager, loggerManager);
        this.stepList = steps;
    }

    public List<DistributionStep> getSteps() {
        return this.stepList != null ? this.stepList : Collections.emptyList();
    }

    public DistributionStep getStep(String stepId) {
        for (DistributionStep step : this.getSteps()) {
            if (!StringUtils.equals((CharSequence)step.getId(), (CharSequence)stepId)) continue;
            return step;
        }
        return null;
    }

    public int getCurrentStateIndex() {
        return this.currentStateIndex;
    }

    public DistributionStep getCurrentStep() {
        return this.getCurrentStateIndex() < this.getSteps().size() ? this.getSteps().get(this.getCurrentStateIndex()) : null;
    }

    public void setCurrentStateIndex(int currentStateIndex) {
        this.currentStateIndex = currentStateIndex;
    }

    public ExtensionId getPreviousDistributionExtension() {
        return this.previousDistributionExtension;
    }

    public void setPreviousDistributionExtension(ExtensionId previousDistributionExtension) {
        this.previousDistributionExtension = previousDistributionExtension;
    }

    public ExtensionId getPreviousDistributionExtensionUI() {
        return this.previousDistributionExtensionUi;
    }

    public void setPreviousDistributionExtensionUI(ExtensionId previousDistributionExtensionUI) {
        this.previousDistributionExtensionUi = previousDistributionExtensionUI;
    }

    public ExtensionId getDistributionExtension() {
        return this.distributionExtension;
    }

    public void setDistributionExtension(ExtensionId distributionExtension) {
        this.distributionExtension = distributionExtension;
    }

    public ExtensionId getDistributionExtensionUI() {
        return this.distributionExtensionUi;
    }

    public void setDistributionExtensionUI(ExtensionId distributionExtensionUI) {
        this.distributionExtensionUi = distributionExtensionUI;
    }

    public static DistributionManager.DistributionState getDistributionState(ExtensionId previousExtensionId, ExtensionId distributionExtensionId) {
        int diff;
        DistributionManager.DistributionState distributionState = distributionExtensionId != null ? (previousExtensionId == null ? DistributionManager.DistributionState.NEW : (previousExtensionId.equals((Object)distributionExtensionId) ? DistributionManager.DistributionState.SAME : (!distributionExtensionId.getId().equals(previousExtensionId.getId()) ? DistributionManager.DistributionState.DIFFERENT : ((diff = distributionExtensionId.getVersion().compareTo((Object)previousExtensionId.getVersion())) > 0 ? DistributionManager.DistributionState.UPGRADE : DistributionManager.DistributionState.DOWNGRADE)))) : DistributionManager.DistributionState.NONE;
        return distributionState;
    }

    public DistributionManager.DistributionState getDistributionState() {
        return DistributionJobStatus.getDistributionState(this.getPreviousDistributionExtension(), this.getDistributionExtension());
    }

    void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    Object getproperty(String key) {
        return this.properties.get(key);
    }

    void removeProperty(String key) {
        this.properties.remove(key);
    }
}

