/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job.step;

import javax.inject.Inject;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ExtensionRewriter;
import org.xwiki.extension.distribution.internal.job.step.AbstractDistributionStep;
import org.xwiki.extension.job.ExtensionRequest;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.script.ScriptExtensionRewriter;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.model.reference.DocumentReference;

public abstract class AbstractExtensionDistributionStep
extends AbstractDistributionStep {
    @Inject
    protected JobExecutor jobExecutor;

    public AbstractExtensionDistributionStep(String stepId) {
        super(stepId);
    }

    protected void install(ExtensionId extensionId, boolean jarOnRoot) throws JobException, InterruptedException {
        this.install(extensionId, this.getNamespace().toString(), jarOnRoot);
    }

    protected void install(ExtensionId extensionId, String namespace, boolean jarOnRoot) throws JobException, InterruptedException {
        InstallRequest installRequest = new InstallRequest();
        installRequest.setId(ExtensionRequest.getJobId((String)"action", (String)extensionId.getId(), (String)namespace));
        installRequest.addExtension(extensionId);
        installRequest.addNamespace(namespace);
        installRequest.setRootModificationsAllowed(true);
        installRequest.setInteractive(false);
        if (jarOnRoot) {
            ScriptExtensionRewriter rewriter = new ScriptExtensionRewriter();
            rewriter.installExtensionTypeOnRootNamespace("jar");
            rewriter.installExtensionTypeOnRootNamespace("webjar");
            installRequest.setRewriter((ExtensionRewriter)rewriter);
        }
        installRequest.setProperty("user.reference", (Object)new DocumentReference("xwiki", "XWiki", "superadmin"));
        installRequest.setExtensionProperty("user.reference", (Object)"XWiki.superadmin");
        this.jobExecutor.execute("install", (Request)installRequest).join();
    }
}

