/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job.step;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.distribution.internal.job.step.AbstractExtensionDistributionStep;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;
import org.xwiki.extension.job.ExtensionRequest;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.job.plan.ExtensionPlanNode;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.Request;

@Component
@Named(value="extension.outdatedextensions")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class OutdatedExtensionsDistributionStep
extends AbstractExtensionDistributionStep {
    public static final String ID = "extension.outdatedextensions";
    @Inject
    private transient InstalledExtensionRepository installedRepository;
    @Inject
    private transient Logger logger;

    public OutdatedExtensionsDistributionStep() {
        super(ID);
    }

    @Override
    public void prepare() {
        block6: {
            if (this.getState() != null) break block6;
            this.setState(DistributionStep.State.COMPLETED);
            if (this.isMainWiki()) {
                Collection installedExtensions = this.installedRepository.getInstalledExtensions();
                block0: for (InstalledExtension extension : installedExtensions) {
                    Collection installedNamespaces = extension.getNamespaces();
                    if (installedNamespaces == null) {
                        if (extension.isValid(null)) continue;
                        this.logger.debug("Enabling outdate extension step on main wiki because extension [{}] is invalid on root namespace", (Object)extension.getId());
                        this.setState(null);
                        break;
                    }
                    for (String installedNamespace : installedNamespaces) {
                        if (extension.isValid(installedNamespace)) continue;
                        this.logger.debug("Enabling outdate extension step on main wiki because extension [{}] is invalid on namespace [{}]", (Object)extension.getId(), (Object)installedNamespace);
                        this.setState(null);
                        continue block0;
                    }
                }
            } else {
                Namespace currentNamespace = this.getNamespace();
                Collection installedExtensions = this.installedRepository.getInstalledExtensions(currentNamespace.toString());
                for (InstalledExtension extension : installedExtensions) {
                    if (extension.isValid(currentNamespace.toString())) continue;
                    this.logger.debug("Enabling outdate extension step on wiki [{}]because extension [{}] is invalid", (Object)this.getWiki(), (Object)extension.getId());
                    this.setState(null);
                    break;
                }
            }
        }
    }

    @Override
    public void executeNonInteractive() throws Exception {
        if (this.isMainWiki()) {
            Collection installedExtensions = this.installedRepository.getInstalledExtensions();
            for (InstalledExtension extension : installedExtensions) {
                Collection installedNamespaces = extension.getNamespaces();
                if (installedNamespaces == null) {
                    if (extension.isValid(null)) continue;
                    this.repair(extension.getId(), null);
                    continue;
                }
                for (String installedNamespace : installedNamespaces) {
                    if (extension.isValid(installedNamespace)) continue;
                    this.repair(extension.getId(), installedNamespace);
                }
            }
        } else {
            String currentNamespace = this.getNamespace().toString();
            Collection installedExtensions = this.installedRepository.getInstalledExtensions(currentNamespace);
            for (InstalledExtension extension : installedExtensions) {
                if (extension.isValid(currentNamespace)) continue;
                this.repair(extension.getId(), currentNamespace);
            }
        }
        this.setState(DistributionStep.State.COMPLETED);
    }

    private void repair(ExtensionId invalidExtension, String namespace) throws JobException, InterruptedException {
        ExtensionPlan plan = this.createRepairPlan(invalidExtension, namespace);
        if (plan.getTree().size() > 0) {
            ExtensionPlanAction action = ((ExtensionPlanNode)plan.getTree().iterator().next()).getAction();
            this.install(action.getExtension().getId(), namespace, false);
        }
    }

    private ExtensionPlan createRepairPlan(ExtensionId invalidExtension, String namespace) throws JobException, InterruptedException {
        InstallRequest installRequest = new InstallRequest();
        installRequest.setId(ExtensionRequest.getJobId((String)"plan", (String)invalidExtension.getId(), (String)namespace));
        installRequest.addExtension(invalidExtension);
        installRequest.addNamespace(namespace);
        installRequest.setUninstallAllowed(false);
        installRequest.setRootModificationsAllowed(true);
        installRequest.setInteractive(false);
        installRequest.setExtensionProperty("user.reference", (Object)"XWiki.superadmin");
        Job job = this.jobExecutor.execute("upgradeplan", (Request)installRequest);
        job.join();
        return (ExtensionPlan)job.getStatus();
    }
}

