/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job.step;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.distribution.internal.job.step.AbstractDistributionStep;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.platform.flavor.FlavorManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="extension.flavor.wikis")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class WikisFlavorDistributionStep
extends AbstractDistributionStep {
    public static final String ID = "extension.flavor.wikis";
    private transient FlavorManager flavorManager;
    @Inject
    private transient InstalledExtensionRepository installedRepository;
    @Inject
    private transient Logger logger;

    public WikisFlavorDistributionStep() {
        super(ID);
    }

    @Override
    public void prepare() {
        if (this.getState() == null) {
            Collection wikiIds;
            this.setState(DistributionStep.State.COMPLETED);
            if (!this.isMainWiki()) {
                return;
            }
            WikiDescriptorManager wikiDescriptorManager = (WikiDescriptorManager)this.wikiDescriptorManagerProvider.get();
            try {
                wikiIds = wikiDescriptorManager.getAllIds();
            }
            catch (WikiManagerException e) {
                this.logger.error("Failed to get the list of wikis", (Throwable)e);
                this.setState(null);
                return;
            }
            String mainWiki = wikiDescriptorManager.getMainWikiId();
            for (String wikiId : wikiIds) {
                if (mainWiki.equals(wikiId)) continue;
                String namespace = "wiki:" + wikiId;
                ExtensionId flavor = this.flavorManager.getFlavorOfWiki(this.getWiki());
                if (flavor != null && this.installedRepository.getInstalledExtension(flavor).isValid(namespace)) continue;
                this.setState(null);
                return;
            }
        }
    }
}

