/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.distribution.internal.job.step;

import com.xpn.xwiki.internal.template.TemplateManager;
import javax.inject.Inject;
import javax.inject.Provider;
import org.xwiki.extension.distribution.internal.job.DistributionJob;
import org.xwiki.extension.distribution.internal.job.DistributionJobStatus;
import org.xwiki.extension.distribution.internal.job.step.DistributionStep;
import org.xwiki.rendering.block.Block;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

public abstract class AbstractDistributionStep
implements DistributionStep {
    @Inject
    protected transient TemplateManager renderer;
    @Inject
    protected transient Provider<WikiDescriptorManager> wikiDescriptorManagerProvider;
    private final String stepId;
    protected DistributionJob distributionJob;
    private DistributionStep.State state;

    public AbstractDistributionStep(String stepId) {
        this.stepId = stepId;
    }

    @Override
    public void initialize(DistributionJob distributionJob) {
        DistributionStep previousStep;
        this.distributionJob = distributionJob;
        DistributionJobStatus<?> previousStatus = this.distributionJob.getPreviousStatus();
        if (previousStatus != null && previousStatus.getDistributionExtension().equals((Object)this.distributionJob.getStatus().getDistributionExtension()) && (previousStep = previousStatus.getStep(this.getId())) != null) {
            this.setState(previousStep.getState());
        }
        if (this.getState() == null) {
            this.prepare();
        }
    }

    @Override
    public String getId() {
        return this.stepId;
    }

    @Override
    public DistributionStep.State getState() {
        return this.state;
    }

    @Override
    public void setState(DistributionStep.State stepState) {
        this.state = stepState;
    }

    protected String getWiki() {
        return this.distributionJob.getRequest().getWiki();
    }

    protected boolean isMainWiki() {
        return ((WikiDescriptorManager)this.wikiDescriptorManagerProvider.get()).getMainWikiId().equals(this.getWiki());
    }

    protected String getNamespace() {
        String wiki = this.getWiki();
        return wiki == null ? null : "wiki:" + this.getWiki();
    }

    protected String getTemplate() {
        return "distribution/" + this.getId() + ".wiki";
    }

    @Override
    public Block execute() {
        return this.renderer.executeNoException(this.getTemplate());
    }
}

