/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.extension.xar.internal.handler.packager;

import java.util.LinkedHashMap;
import java.util.Map;

import org.xwiki.xar.XarEntry;

/**
 * 
 * @version $Id: 9a32c3b19692590a74d4f818e07fb3d554c6c80d $
 * @since 4.0M1
 */
public class XarMergeResult
{
    private Map<XarEntry, XarEntryMergeResult> mergeResults = new LinkedHashMap<XarEntry, XarEntryMergeResult>();

    public Map<XarEntry, XarEntryMergeResult> getMergeResults()
    {
        return this.mergeResults;
    }

    public void addMergeResult(XarEntryMergeResult mergeResult)
    {
        this.mergeResults.put(mergeResult.getEntry(), mergeResult);
    }
}
