/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.security;

import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.xar.XarExtensionConfiguration;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtensionRepository;
import org.xwiki.extension.xar.internal.security.XarSecurityRule;
import org.xwiki.extension.xar.internal.security.XarSecurityTool;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.SecurityReference;
import org.xwiki.security.authorization.AuthorizationException;
import org.xwiki.security.authorization.Right;
import org.xwiki.security.authorization.SecurityEntryReaderExtra;
import org.xwiki.security.authorization.SecurityRule;

@Component
@Named(value="xar")
@Singleton
public class XarSecurityEntryReaderExtra
implements SecurityEntryReaderExtra {
    @Inject
    @Named(value="xar")
    private InstalledExtensionRepository xarRepository;
    @Inject
    private XarExtensionConfiguration configuration;
    @Inject
    private XarSecurityTool securityTool;

    public Collection<SecurityRule> read(SecurityReference entityReference) throws AuthorizationException {
        XarExtensionConfiguration.DocumentProtection protection = this.configuration.getDocumentProtection();
        if (protection.isDeny() && entityReference.getType().ordinal() >= EntityType.DOCUMENT.ordinal()) {
            EntityReference reference = entityReference.extractReference(EntityType.DOCUMENT);
            DocumentReference documentReference = reference instanceof DocumentReference ? (DocumentReference)reference : new DocumentReference(reference);
            if (!((XarInstalledExtensionRepository)this.xarRepository).isAllowed(documentReference, Right.EDIT)) {
                return Collections.singletonList(new XarSecurityRule(Right.EDIT, protection.isSimple(), this.securityTool));
            }
            if (!((XarInstalledExtensionRepository)this.xarRepository).isAllowed(documentReference, Right.DELETE)) {
                return Collections.singletonList(new XarSecurityRule(Right.DELETE, protection.isSimple(), this.securityTool));
            }
        }
        return null;
    }
}

