/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.doc;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;

@Component(roles={NestedPageCounter.class})
@Singleton
public class NestedPageCounter {
    @Inject
    private Logger logger;
    @Inject
    private EntityReferenceProvider defaultEntityReferenceProvider;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="count")
    private QueryFilter countFilter;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localEntityReferenceSerializer;

    public long countNestedPages(DocumentReference rootReference) {
        String defaultDocumentName = this.defaultEntityReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName();
        if (!rootReference.getName().equals(defaultDocumentName)) {
            return 0L;
        }
        String isDefaultTranslation = "doc.translation = 0";
        String isDirectChild = "(doc.space = :space and doc.name <> :defaultDocumentName)";
        String isIndirectChild = "doc.space like :spacePrefix";
        try {
            Query query = this.queryManager.createQuery("where " + isDefaultTranslation + " and (" + isDirectChild + " or " + isIndirectChild + ")", "hql");
            query.bindValue("defaultDocumentName", (Object)defaultDocumentName);
            query.bindValue("space", this.localEntityReferenceSerializer.serialize(rootReference.getParent(), new Object[0]));
            String spacePrefix = (String)this.localEntityReferenceSerializer.serialize((EntityReference)new DocumentReference(String.valueOf('X'), rootReference.getLastSpaceReference()), new Object[0]);
            spacePrefix = StringUtils.removeEnd((String)spacePrefix, (String)String.valueOf('X'));
            query.bindValue("spacePrefix").literal(spacePrefix).anyChars();
            query.addFilter(this.countFilter);
            return (Long)query.execute().get(0);
        }
        catch (QueryException e) {
            this.logger.warn("Failed to count the nested pages inside [{}]. Root cause is: [{}]", (Object)rootReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            this.logger.debug("Stacktrace:", (Throwable)e);
            return 0L;
        }
    }
}

