/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.delete;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentsDeletingEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.xar.XarExtensionConfiguration;
import org.xwiki.extension.xar.internal.delete.question.ExtensionBreakingQuestion;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtensionRepository;
import org.xwiki.job.Job;
import org.xwiki.job.event.status.CancelableJobStatus;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.CancelableEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.refactoring.job.question.EntitySelection;
import org.xwiki.security.authorization.Right;

@Component
@Singleton
@Named(value="DocumentsDeletingListener")
public class DocumentsDeletingListener
extends AbstractEventListener {
    private static final List<Event> EVENTS = Arrays.asList(new DocumentsDeletingEvent());
    @Inject
    @Named(value="xar")
    private InstalledExtensionRepository installedExtensionRepository;
    @Inject
    private XarExtensionConfiguration configuration;
    @Inject
    private Logger logger;

    public DocumentsDeletingListener() {
        super("XAR Extension Documents Deleting Listener", EVENTS);
    }

    private boolean shouldListenerBeTriggered(Job job, CancelableEvent event) {
        if (event.isCanceled()) {
            this.logger.debug("Skipping [{}] as the event is already cancelled.", (Object)this.getName());
            return false;
        }
        if (this.configuration.getDocumentProtection() == XarExtensionConfiguration.DocumentProtection.NONE) {
            return false;
        }
        if (!job.getRequest().isInteractive()) {
            this.logger.warn("XAR Extension Documents Deleting Listener will not check the document in non-interactive mode.");
            return false;
        }
        return true;
    }

    public void onEvent(Event event, Object source, Object data) {
        Job job = (Job)source;
        CancelableEvent cancelableEvent = (CancelableEvent)event;
        if (!this.shouldListenerBeTriggered(job, cancelableEvent)) {
            return;
        }
        Map concernedEntities = (Map)data;
        ExtensionBreakingQuestion question = new ExtensionBreakingQuestion(concernedEntities);
        for (EntitySelection entitySelection : concernedEntities.values()) {
            if (!(entitySelection.getEntityReference() instanceof DocumentReference)) continue;
            this.checkIfDeleteIsAllowed(entitySelection, question);
        }
        JobStatus jobStatus = job.getStatus();
        if (!question.getExtensions().isEmpty()) {
            question.unselectAll();
            try {
                boolean ack = jobStatus.ask((Object)question, 5L, TimeUnit.MINUTES);
                if (!ack) {
                    String message = "The question has been asked, however no answer has been received.";
                    this.logger.warn(message);
                    cancelableEvent.cancel(message);
                }
            }
            catch (InterruptedException e) {
                this.logger.warn("Confirm question has been interrupted.");
                cancelableEvent.cancel("Question has been interrupted.");
            }
            if (jobStatus instanceof CancelableJobStatus) {
                CancelableJobStatus cancelableJobStatus = (CancelableJobStatus)jobStatus;
                if (cancelableJobStatus.isCanceled()) {
                    cancelableEvent.cancel();
                }
                if (cancelableEvent.isCanceled()) {
                    cancelableJobStatus.cancel();
                }
            }
        }
    }

    private void checkIfDeleteIsAllowed(EntitySelection entitySelection, ExtensionBreakingQuestion question) {
        XarInstalledExtensionRepository repository = (XarInstalledExtensionRepository)this.installedExtensionRepository;
        DocumentReference documentReference = (DocumentReference)entitySelection.getEntityReference();
        if (repository.isAllowed(documentReference, Right.DELETE)) {
            question.markAsFreePage(entitySelection);
            return;
        }
        Collection<XarInstalledExtension> extensions = repository.getXarInstalledExtensions(documentReference);
        for (XarInstalledExtension extension : extensions) {
            question.pageBelongsToExtension(entitySelection, extension);
        }
    }
}

