/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.doc;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.SpaceReference;

@Component(roles={InstalledExtensionDocumentTree.class})
@Singleton
public class InstalledExtensionDocumentTree {
    private final Map<EntityReference, InstalledExtensionDocumentTreeNode> nodes = new ConcurrentHashMap<EntityReference, InstalledExtensionDocumentTreeNode>();
    @Inject
    private EntityReferenceProvider defaultEntityReferenceProvider;

    public Set<DocumentReference> getChildren(EntityReference parentReference) {
        InstalledExtensionDocumentTreeNode parentNode = this.nodes.get(parentReference);
        return parentNode == null ? Collections.emptySet() : parentNode.children;
    }

    public boolean isExtensionPage(DocumentReference documentReference) {
        InstalledExtensionDocumentTreeNode node = this.nodes.get(documentReference);
        return node != null && node.customizedLocales != null;
    }

    public boolean isCustomizedExtensionPage(DocumentReference documentReference) {
        InstalledExtensionDocumentTreeNode node = this.nodes.get(documentReference);
        return node != null && node.customizedLocales != null && !node.customizedLocales.isEmpty();
    }

    public Set<DocumentReference> getNestedExtensionPages(EntityReference rootReference) {
        HashSet<DocumentReference> documentReferences = new HashSet<DocumentReference>();
        LinkedList<DocumentReference> queue = new LinkedList<DocumentReference>(this.getChildren(rootReference));
        while (!queue.isEmpty()) {
            DocumentReference parentReference = (DocumentReference)queue.remove();
            queue.addAll(this.getChildren((EntityReference)parentReference));
            if (!this.isExtensionPage(parentReference)) continue;
            documentReferences.add(parentReference);
        }
        return documentReferences;
    }

    public Set<DocumentReference> getNestedCustomizedExtensionPages(EntityReference rootReference) {
        return this.getNestedExtensionPages(rootReference).stream().filter(this::isCustomizedExtensionPage).collect(Collectors.toSet());
    }

    protected void setCustomizedExtensionPage(DocumentReference documentReference, boolean customized) {
        DocumentReference documentReferenceWithoutLocale = new DocumentReference((EntityReference)documentReference, (Locale)null);
        InstalledExtensionDocumentTreeNode node = this.nodes.get(documentReferenceWithoutLocale);
        if (node != null && node.customizedLocales != null) {
            if (customized) {
                node.customizedLocales.add(documentReference.getLocale());
            } else {
                node.customizedLocales.remove(documentReference.getLocale());
            }
        }
    }

    protected void addExtensionPage(DocumentReference documentReference) {
        InstalledExtensionDocumentTreeNode node = this.nodes.get(documentReference);
        if (node != null) {
            if (node.customizedLocales == null) {
                node.customizedLocales = new CopyOnWriteArraySet<Locale>();
            }
        } else {
            node = this.addNode((EntityReference)documentReference);
            node.customizedLocales = new CopyOnWriteArraySet<Locale>();
        }
    }

    private InstalledExtensionDocumentTreeNode addNode(EntityReference entityReference) {
        EntityReference parentReference = this.getParentReference(entityReference);
        if (parentReference != null) {
            InstalledExtensionDocumentTreeNode parentNode = this.nodes.get(parentReference);
            if (parentNode == null) {
                parentNode = this.addNode(parentReference);
            }
            parentNode.children.add((DocumentReference)entityReference);
        }
        InstalledExtensionDocumentTreeNode node = new InstalledExtensionDocumentTreeNode();
        this.nodes.put(entityReference, node);
        return node;
    }

    protected void removeExtensionPage(DocumentReference documentReference) {
        InstalledExtensionDocumentTreeNode node = this.nodes.get(documentReference);
        if (node != null) {
            if (node.children.isEmpty()) {
                this.removeNode((EntityReference)documentReference);
            } else {
                node.customizedLocales = null;
            }
        }
    }

    private void removeNode(EntityReference entityReference) {
        InstalledExtensionDocumentTreeNode parentNode;
        EntityReference parentReference = this.getParentReference(entityReference);
        if (parentReference != null && (parentNode = this.nodes.get(parentReference)) != null) {
            parentNode.children.remove(entityReference);
            if (parentNode.children.isEmpty() && parentNode.customizedLocales == null) {
                this.removeNode(parentReference);
            }
        }
        this.nodes.remove(entityReference);
    }

    private EntityReference getParentReference(EntityReference entityReference) {
        if (entityReference.getType() == EntityType.DOCUMENT) {
            DocumentReference documentReference = (DocumentReference)entityReference;
            SpaceReference spaceReference = documentReference.getLastSpaceReference();
            String defaultDocumentName = this.defaultEntityReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName();
            if (documentReference.getName().equals(defaultDocumentName)) {
                if (spaceReference.getParent().getType() == EntityType.SPACE) {
                    return new DocumentReference(defaultDocumentName, new SpaceReference(spaceReference.getParent()));
                }
                return documentReference.getWikiReference();
            }
            return new DocumentReference(defaultDocumentName, spaceReference);
        }
        return null;
    }

    private static class InstalledExtensionDocumentTreeNode {
        public Set<Locale> customizedLocales;
        public Set<DocumentReference> children = Collections.newSetFromMap(new ConcurrentHashMap());

        private InstalledExtensionDocumentTreeNode() {
        }
    }
}

