/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager;

import java.util.EnumMap;
import java.util.Map;
import org.xwiki.extension.xar.internal.handler.XarExtensionPlan;
import org.xwiki.extension.xar.question.ConflictQuestion;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.xar.XarEntry;

public class PackageConfiguration
implements Cloneable {
    private String wiki;
    private DocumentReference user;
    private boolean interactive;
    private JobStatus jobStatus;
    private boolean verbose = false;
    private XarExtensionPlan xarExtensionPlan;
    private Map<String, XarEntry> entriesToImport;
    private boolean skipMandatorytDocuments = true;
    private final Map<ConflictQuestion.ConflictType, ConflictQuestion.GlobalAction> conflictActions = new EnumMap<ConflictQuestion.ConflictType, ConflictQuestion.GlobalAction>(ConflictQuestion.ConflictType.class);
    private XarEntry xarEntry;

    public PackageConfiguration() {
        this.setConflictAction(ConflictQuestion.ConflictType.CURRENT_DELETED, ConflictQuestion.GlobalAction.CURRENT);
        this.setConflictAction(ConflictQuestion.ConflictType.MERGE_SUCCESS, ConflictQuestion.GlobalAction.MERGED);
    }

    public PackageConfiguration clone() {
        try {
            return (PackageConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getWiki() {
        return this.wiki;
    }

    public void setWiki(String wiki) {
        this.wiki = wiki;
    }

    public DocumentReference getUserReference() {
        return this.user;
    }

    public void setUser(DocumentReference user) {
        this.user = user;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public JobStatus getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Map<String, XarEntry> getEntriesToImport() {
        return this.entriesToImport;
    }

    public void setEntriesToImport(Map<String, XarEntry> entriesToImport) {
        this.entriesToImport = entriesToImport;
    }

    public XarExtensionPlan getXarExtensionPlan() {
        return this.xarExtensionPlan;
    }

    public void setXarExtensionPlan(XarExtensionPlan xarExtensionPlan) {
        this.xarExtensionPlan = xarExtensionPlan;
    }

    public boolean isSkipMandatorytDocuments() {
        return this.skipMandatorytDocuments;
    }

    public void setSkipMandatorytDocuments(boolean skipMandatorytDocuments) {
        this.skipMandatorytDocuments = skipMandatorytDocuments;
    }

    public ConflictQuestion.GlobalAction getConflictAction(ConflictQuestion.ConflictType type) {
        return this.conflictActions.get((Object)type);
    }

    public void setConflictAction(ConflictQuestion.ConflictType type, ConflictQuestion.GlobalAction action) {
        this.setConflictAction(type, action, action);
    }

    public void setConflictAction(ConflictQuestion.ConflictType type, ConflictQuestion.GlobalAction action, ConflictQuestion.GlobalAction defaultAnswer) {
        this.conflictActions.put(type, action != null ? action : defaultAnswer);
    }

    public Map<ConflictQuestion.ConflictType, ConflictQuestion.GlobalAction> getConflictActions() {
        return this.conflictActions;
    }

    public void setXarEntry(XarEntry xarEntry) {
        this.xarEntry = xarEntry;
    }

    public XarEntry getXarEntry() {
        return this.xarEntry;
    }
}

