/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.repository;

import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.Extension;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.event.ExtensionEvent;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.event.ExtensionUninstalledEvent;
import org.xwiki.extension.event.ExtensionUpgradedEvent;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.xar.internal.event.XarExtensionInstalledEvent;
import org.xwiki.extension.xar.internal.event.XarExtensionUninstalledEvent;
import org.xwiki.extension.xar.internal.event.XarExtensionUpgradedEvent;
import org.xwiki.extension.xar.internal.handler.UnsupportedNamespaceException;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtensionRepository;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component
@Named(value="org.xwiki.extension.xar.internal.repository.InstalledExtensionSynchronizer")
@Singleton
public class InstalledExtensionSynchronizer
extends AbstractEventListener {
    @Inject
    @Named(value="xar")
    private InstalledExtensionRepository xarRepository;
    @Inject
    private Logger logger;
    @Inject
    private Provider<ObservationManager> observationManagerProvider;

    public InstalledExtensionSynchronizer() {
        super(InstalledExtensionSynchronizer.class.getName(), new Event[]{new ExtensionInstalledEvent(), new ExtensionUninstalledEvent(), new ExtensionUpgradedEvent()});
    }

    private XarInstalledExtensionRepository getXarRepository() {
        return (XarInstalledExtensionRepository)this.xarRepository;
    }

    public void onEvent(Event event, Object source, Object data) {
        ExtensionEvent extensionEvent = (ExtensionEvent)event;
        try {
            if (extensionEvent instanceof ExtensionUninstalledEvent) {
                this.getXarRepository().pagesRemoved(extensionEvent.getExtensionId(), extensionEvent.getNamespace());
                this.getXarRepository().updateCachedXarExtension(extensionEvent.getExtensionId());
            } else {
                if (data != null) {
                    for (InstalledExtension installedExtension : (Collection)data) {
                        this.getXarRepository().pagesRemoved(installedExtension.getId(), extensionEvent.getNamespace());
                        this.getXarRepository().updateCachedXarExtension(installedExtension.getId());
                    }
                }
                this.getXarRepository().updateCachedXarExtension(extensionEvent.getExtensionId());
                this.getXarRepository().pagesAdded(extensionEvent.getExtensionId(), extensionEvent.getNamespace());
            }
        }
        catch (UnsupportedNamespaceException e) {
            this.logger.error("Failed to extract wiki from namespace [{}]", (Object)extensionEvent.getNamespace());
        }
        this.maybeTriggerXarExtensionEvent((ExtensionEvent)event, (InstalledExtension)source, (Collection)data);
    }

    private void maybeTriggerXarExtensionEvent(ExtensionEvent event, InstalledExtension source, Collection<InstalledExtension> data) {
        if (this.isXarExtension((Extension)source) || data != null && data.stream().anyMatch(this::isXarExtension)) {
            InstalledExtension newSource = this.asXarInstalledExtension(source);
            Collection newData = data == null ? null : (Collection)data.stream().map(this::asXarInstalledExtension).collect(Collectors.toList());
            ObservationManager observationManager = (ObservationManager)this.observationManagerProvider.get();
            if (event instanceof ExtensionInstalledEvent) {
                observationManager.notify((Event)new XarExtensionInstalledEvent((ExtensionInstalledEvent)event), (Object)newSource, (Object)newData);
            } else if (event instanceof ExtensionUninstalledEvent) {
                observationManager.notify((Event)new XarExtensionUninstalledEvent((ExtensionUninstalledEvent)event), (Object)newSource, (Object)newData);
            } else if (event instanceof ExtensionUpgradedEvent) {
                observationManager.notify((Event)new XarExtensionUpgradedEvent((ExtensionUpgradedEvent)event), (Object)newSource, (Object)newData);
            }
        }
    }

    private boolean isXarExtension(Extension extension) {
        return "xar".equals(extension.getType());
    }

    private InstalledExtension asXarInstalledExtension(InstalledExtension extension) {
        if (extension instanceof XarInstalledExtension) {
            return extension;
        }
        if ("xar".equals(extension.getType())) {
            return this.getXarRepository().getInstalledExtension(extension.getId());
        }
        return extension;
    }
}

