/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.question;

import com.xpn.xwiki.doc.XWikiDocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.diff.Conflict;
import org.xwiki.diff.ConflictDecision;
import org.xwiki.diff.internal.DefaultConflictDecision;

public class ConflictQuestion {
    private static final String PREFIX_REQUEST_CONFLICT_DEFAULTANSWER = "extension.xar.packager.conflict.always.";
    public static final String REQUEST_CONFLICT_DEFAULTANSWER_MERGE_SUCCESS = ConflictQuestion.toKey(ConflictType.MERGE_SUCCESS);
    public static final String REQUEST_CONFLICT_DEFAULTANSWER_MERGE_FAILURE = ConflictQuestion.toKey(ConflictType.MERGE_FAILURE);
    public static final String REQUEST_CONFLICT_DEFAULTANSWER_CURRENT_EXIST = ConflictQuestion.toKey(ConflictType.CURRENT_EXIST);
    public static final String REQUEST_CONFLICT_DEFAULTANSWER_CURRENT_DELETED = ConflictQuestion.toKey(ConflictType.CURRENT_DELETED);
    private final ConflictType type;
    private final XWikiDocument currentDocument;
    private final XWikiDocument previousDocument;
    private final XWikiDocument nextDocument;
    private final XWikiDocument mergedDocument;
    private List<Conflict<?>> documentConflicts;
    private GlobalAction globalAction;
    private XWikiDocument customDocument;
    private boolean always;
    private Map<Conflict<?>, ConflictDecision<?>> conflictDecisions;

    public static String toKey(ConflictType type) {
        return PREFIX_REQUEST_CONFLICT_DEFAULTANSWER + (Object)((Object)type);
    }

    @Deprecated
    public ConflictQuestion(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, XWikiDocument mergedDocument) {
        this(currentDocument, previousDocument, nextDocument, mergedDocument, null);
    }

    public ConflictQuestion(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, XWikiDocument mergedDocument, ConflictType type) {
        this(currentDocument, previousDocument, nextDocument, mergedDocument, type, null);
    }

    public ConflictQuestion(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, XWikiDocument mergedDocument, ConflictType type, List<Conflict<?>> documentConflicts) {
        this.currentDocument = currentDocument;
        this.previousDocument = previousDocument;
        this.nextDocument = nextDocument;
        this.mergedDocument = mergedDocument;
        this.type = type;
        if (this.type == ConflictType.CURRENT_EXIST) {
            this.setGlobalAction(GlobalAction.NEXT);
        } else if (this.type == ConflictType.CURRENT_DELETED) {
            this.setGlobalAction(GlobalAction.CURRENT);
        } else {
            this.setGlobalAction(GlobalAction.MERGED);
        }
        this.documentConflicts = documentConflicts;
        this.conflictDecisions = new HashMap();
    }

    public ConflictType getType() {
        return this.type;
    }

    public XWikiDocument getCurrentDocument() {
        return this.currentDocument;
    }

    public XWikiDocument getPreviousDocument() {
        return this.previousDocument;
    }

    public XWikiDocument getNextDocument() {
        return this.nextDocument;
    }

    public XWikiDocument getMergedDocument() {
        return this.mergedDocument;
    }

    public List<Conflict<?>> getDocumentConflicts() {
        return this.documentConflicts;
    }

    public GlobalAction getGlobalAction() {
        return this.globalAction;
    }

    public void setGlobalAction(GlobalAction globalAction) {
        this.globalAction = globalAction;
    }

    public XWikiDocument getCustomDocument() {
        return this.customDocument;
    }

    public void setCustomDocument(XWikiDocument customDocument) {
        this.customDocument = customDocument;
        this.globalAction = GlobalAction.CUSTOM;
    }

    public boolean isAlways() {
        return this.always;
    }

    public void setAlways(boolean always) {
        this.always = always;
    }

    public void setConflictDecision(String conflictReference, String decisionType, String customValue) {
        Conflict conflict = this.findConflictFromReference(conflictReference);
        ConflictDecision.DecisionType type = ConflictDecision.DecisionType.valueOf((String)decisionType.toUpperCase());
        DefaultConflictDecision decision = new DefaultConflictDecision(conflict);
        decision.setType(type);
        if (!StringUtils.isEmpty((CharSequence)customValue)) {
            decision.setCustom(Collections.singletonList(customValue));
        }
        this.conflictDecisions.put((Conflict<?>)conflict, (ConflictDecision<?>)decision);
    }

    private Conflict findConflictFromReference(String reference) {
        for (Conflict<?> documentConflict : this.documentConflicts) {
            if (!documentConflict.getReference().equals(reference)) continue;
            return documentConflict;
        }
        throw new IllegalArgumentException(String.format("The conflict [%s] cannot be found.", reference));
    }

    public List<ConflictDecision> getDecisions() {
        return new ArrayList<ConflictDecision>(this.conflictDecisions.values());
    }

    public static enum GlobalAction {
        CURRENT,
        PREVIOUS,
        NEXT,
        MERGED,
        CUSTOM,
        ASK;

    }

    public static enum ConflictType {
        MERGE_SUCCESS(GlobalAction.ASK, GlobalAction.CURRENT, GlobalAction.MERGED, GlobalAction.NEXT, GlobalAction.PREVIOUS),
        MERGE_FAILURE(GlobalAction.ASK, GlobalAction.CURRENT, GlobalAction.MERGED, GlobalAction.NEXT, GlobalAction.PREVIOUS),
        CURRENT_EXIST(GlobalAction.ASK, GlobalAction.CURRENT, GlobalAction.NEXT),
        CURRENT_DELETED(GlobalAction.ASK, GlobalAction.CURRENT, GlobalAction.PREVIOUS, GlobalAction.NEXT);

        private final List<GlobalAction> actions;

        private ConflictType(GlobalAction ... actions) {
            this.actions = Collections.unmodifiableList(Arrays.asList(actions));
        }

        public List<GlobalAction> getActions() {
            return this.actions;
        }
    }
}

