/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager.xml;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import org.dom4j.io.SAXContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.xar.internal.handler.packager.xml.AbstractHandler;
import org.xwiki.extension.xar.internal.handler.packager.xml.AttachmentHandler;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.rendering.syntax.Syntax;

public class DocumentHandler
extends AbstractHandler {
    public SAXContentHandler domBuilder = new SAXContentHandler();

    public DocumentHandler(ComponentManager componentManager, String wiki) {
        super(componentManager);
        this.setCurrentBean(new XWikiDocument(new DocumentReference(wiki, "XWiki", "Page")));
        this.getDocument().setSyntax(Syntax.XWIKI_1_0);
        this.skippedElements.add("version");
        this.skippedElements.add("minorEdit");
        this.skippedElements.add("comment");
        this.skippedElements.add("creator");
        this.skippedElements.add("author");
        this.skippedElements.add("contentAuthor");
        this.skippedElements.add("creationDate");
        this.skippedElements.add("date");
        this.skippedElements.add("contentUpdateDate");
    }

    public XWikiDocument getDocument() {
        return (XWikiDocument)this.getCurrentBean();
    }

    @Override
    public void startElementInternal(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("attachment")) {
            this.setCurrentHandler(new AttachmentHandler(this.getComponentManager()));
        } else if (qName.equals("class") || qName.equals("object")) {
            this.domBuilder.startDocument();
            this.setCurrentHandler((ContentHandler)this.domBuilder);
        } else {
            super.startElementInternal(uri, localName, qName, attributes);
        }
    }

    protected void endAttachment(String uri, String localName, String qName) throws SAXException {
        AttachmentHandler handler = (AttachmentHandler)this.getCurrentHandler();
        this.getDocument().getAttachmentList().add(handler.getAttachment());
    }

    protected void endObject(String uri, String localName, String qName) throws SAXException {
        try {
            BaseObject baseObject = new BaseObject();
            baseObject.fromXML(this.domBuilder.getDocument().getRootElement());
            this.getDocument().setXObject(baseObject.getNumber(), baseObject);
        }
        catch (XWikiException e) {
            throw new SAXException("Failed to parse object", (Exception)((Object)e));
        }
    }

    protected void endClass(String uri, String localName, String qName) throws SAXException {
        try {
            this.getDocument().getXClass().fromXML(this.domBuilder.getDocument().getRootElement());
        }
        catch (XWikiException e) {
            throw new SAXException("Failed to parse object", (Exception)((Object)e));
        }
    }

    @Override
    public void endElementInternal(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("attachment")) {
            this.endAttachment(uri, localName, qName);
        } else if (qName.equals("object")) {
            this.endObject(uri, localName, qName);
        } else if (qName.equals("class")) {
            this.endClass(uri, localName, qName);
        } else {
            super.endElementInternal(uri, localName, qName);
        }
    }
}

