/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.repository;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.event.ExtensionUninstalledEvent;
import org.xwiki.extension.event.ExtensionUpgradedEvent;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryId;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepositoryException;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.repository.XarLocalExtension;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="xar")
public class XarLocalExtensionRepository
extends AbstractExtensionRepository
implements LocalExtensionRepository,
Initializable {
    private static final List<Event> EVENTS = Arrays.asList(new ExtensionInstalledEvent(), new ExtensionUninstalledEvent(), new ExtensionUpgradedEvent());
    @Inject
    private LocalExtensionRepository localRepository;
    @Inject
    private Packager packager;
    @Inject
    private ObservationManager observation;
    @Inject
    private Logger logger;
    private Map<ExtensionId, XarLocalExtension> extensions = new ConcurrentHashMap<ExtensionId, XarLocalExtension>();

    public void initialize() throws InitializationException {
        this.setId(new ExtensionRepositoryId("xar", "xar", this.localRepository.getId().getURI()));
        this.loadExtensions();
        this.observation.addListener(new EventListener(){

            public void onEvent(Event event, Object arg1, Object arg2) {
                LocalExtension extension = (LocalExtension)arg1;
                if (extension.getType().equals("xar")) {
                    XarLocalExtensionRepository.this.updateXarExtension(extension);
                }
                if (arg2 != null) {
                    XarLocalExtensionRepository.this.updateXarExtension((LocalExtension)arg2);
                }
            }

            public String getName() {
                return XarLocalExtensionRepository.class.getName();
            }

            public List<Event> getEvents() {
                return EVENTS;
            }
        });
    }

    private void updateXarExtension(LocalExtension extension) {
        if (this.extensions.containsKey(extension.getId())) {
            if (!extension.isInstalled()) {
                this.removeXarExtension(extension.getId());
            }
        } else if (extension.isInstalled()) {
            try {
                this.addXarExtension(extension);
            }
            catch (IOException e) {
                this.logger.error("Failed to parse extension [" + extension + "]", (Throwable)e);
            }
        }
    }

    private void addXarExtension(LocalExtension extension) throws IOException {
        XarLocalExtension xarExtension = new XarLocalExtension(extension, this, this.packager);
        this.extensions.put(extension.getId(), xarExtension);
    }

    private void removeXarExtension(ExtensionId extensionId) {
        this.extensions.remove(extensionId);
    }

    private void loadExtensions() {
        for (LocalExtension localExtension : this.localRepository.getLocalExtensions()) {
            if (!localExtension.getType().equalsIgnoreCase("xar")) continue;
            try {
                this.addXarExtension(localExtension);
            }
            catch (IOException e) {
                this.logger.error("Failed to parse extension [" + localExtension + "]", (Throwable)e);
            }
        }
    }

    public Extension resolve(ExtensionId extensionId) throws ResolveException {
        Extension extension = (Extension)this.extensions.get(extensionId);
        if (extension == null) {
            throw new ResolveException("Extension [" + extensionId + "] does not exists or is not a xar extension");
        }
        return extension;
    }

    public boolean exists(ExtensionId extensionId) {
        return this.extensions.containsKey(extensionId);
    }

    public int countExtensions() {
        return this.extensions.size();
    }

    public Collection<LocalExtension> getLocalExtensions() {
        return Collections.unmodifiableCollection(this.extensions.values());
    }

    public Collection<LocalExtension> getInstalledExtensions(String namespace) {
        ArrayList<LocalExtension> installedExtensions = new ArrayList<LocalExtension>(this.extensions.size());
        for (XarLocalExtension localExtension : this.extensions.values()) {
            if (!localExtension.isInstalled(namespace)) continue;
            installedExtensions.add((LocalExtension)localExtension);
        }
        return installedExtensions;
    }

    public Collection<LocalExtension> getInstalledExtensions() {
        return this.getLocalExtensions();
    }

    public LocalExtension getInstalledExtension(String id, String namespace) {
        Object extension = this.localRepository.getInstalledExtension(id, namespace);
        extension = extension.getType().equals("xar") ? (LocalExtension)this.extensions.get(extension.getId()) : null;
        return extension;
    }

    public LocalExtension storeExtension(Extension extension) throws LocalExtensionRepositoryException {
        throw new RuntimeException("Not implemented");
    }

    public void removeExtension(LocalExtension extension) throws ResolveException {
        throw new RuntimeException("Not implemented");
    }

    public void installExtension(LocalExtension extension, String namespace, boolean dependency) throws InstallException {
        throw new RuntimeException("Not implemented");
    }

    public void uninstallExtension(LocalExtension extension, String namespace) throws UninstallException {
        throw new RuntimeException("Not implemented");
    }

    public Collection<LocalExtension> getBackwardDependencies(String id, String namespace) throws ResolveException {
        LocalExtension extension = this.localRepository.getInstalledExtension(id, namespace);
        return extension.getType().equals("xar") ? this.localRepository.getBackwardDependencies(id, namespace) : null;
    }

    public Map<String, Collection<LocalExtension>> getBackwardDependencies(ExtensionId extensionId) throws ResolveException {
        LocalExtension extension = (LocalExtension)this.localRepository.resolve(extensionId);
        return extension.getType().equals("xar") ? this.localRepository.getBackwardDependencies(extensionId) : null;
    }
}

