/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager.xml;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.merge.MergeResult;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.xar.internal.handler.ConflictQuestion;
import org.xwiki.extension.xar.internal.handler.packager.DefaultPackager;
import org.xwiki.extension.xar.internal.handler.packager.NotADocumentException;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.XarEntry;
import org.xwiki.extension.xar.internal.handler.packager.XarEntryMergeResult;
import org.xwiki.extension.xar.internal.handler.packager.XarFile;
import org.xwiki.extension.xar.internal.handler.packager.xml.AttachmentHandler;
import org.xwiki.extension.xar.internal.handler.packager.xml.DocumentHandler;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

public class DocumentImporterHandler
extends DocumentHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentImporterHandler.class);
    private XarFile previousXarFile;
    private DefaultPackager packager;
    private XarEntryMergeResult mergeResult;
    private PackageConfiguration configuration;
    private Boolean hasCurrentDocument;

    public DocumentImporterHandler(DefaultPackager packager, ComponentManager componentManager, String wiki) {
        super(componentManager, wiki);
        this.packager = packager;
    }

    public void setPreviousXarFile(XarFile previousXarFile) {
        this.previousXarFile = previousXarFile;
    }

    public void setConfiguration(PackageConfiguration configuration) {
        this.configuration = configuration;
    }

    public XarEntryMergeResult getMergeResult() {
        return this.mergeResult;
    }

    private DocumentReference getUserReference(XWikiContext context) {
        DocumentReference userReference = this.configuration.getUserReference();
        if (userReference == null) {
            userReference = context.getUserReference();
        }
        return userReference;
    }

    private void saveDocument(XWikiDocument document, String comment, XWikiContext context) throws Exception {
        XWikiDocument currentDocument = this.getDatabaseDocument();
        DocumentReference userReference = this.getUserReference(context);
        if (!currentDocument.isNew()) {
            if (document != currentDocument) {
                if (document.isNew()) {
                    currentDocument.apply(document);
                } else {
                    currentDocument = document;
                }
            }
        } else {
            currentDocument = document;
            currentDocument.setCreatorReference(userReference);
        }
        currentDocument.setAuthorReference(userReference);
        currentDocument.setContentAuthorReference(userReference);
        context.getWiki().saveDocument(currentDocument, comment, context);
    }

    private XWikiDocument askDocumentToSave(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, XWikiDocument mergedDocument) {
        XWikiDocument documentToSave;
        ConflictQuestion question = new ConflictQuestion(currentDocument, previousDocument, nextDocument, mergedDocument);
        if (mergedDocument == null) {
            question.setGlobalAction(ConflictQuestion.GlobalAction.NEXT);
        }
        if (this.configuration != null && this.configuration.getJobStatus() != null) {
            try {
                this.configuration.getJobStatus().ask((Object)question);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        switch (question.getGlobalAction()) {
            case CURRENT: {
                documentToSave = currentDocument;
                break;
            }
            case NEXT: {
                documentToSave = nextDocument;
                break;
            }
            case PREVIOUS: {
                documentToSave = previousDocument;
                break;
            }
            case CUSTOM: {
                documentToSave = question.getCustomDocument() != null ? question.getCustomDocument() : mergedDocument;
                break;
            }
            default: {
                documentToSave = mergedDocument;
            }
        }
        return documentToSave;
    }

    private void saveDocument(String comment) throws SAXException {
        try {
            XWikiContext context = this.getXWikiContext();
            XWikiDocument currentDocument = this.getDatabaseDocument();
            XWikiDocument nextDocument = this.getDocument();
            LOGGER.info("Importing document [{}] in language [{}]...", (Object)nextDocument.getPrefixedFullName(), (Object)nextDocument.getRealLanguage());
            if (currentDocument != null && this.hasCurrentDocument == Boolean.TRUE) {
                XWikiDocument previousDocument = this.getPreviousDocument();
                if (previousDocument != null) {
                    XWikiDocument mergedDocument = currentDocument.clone();
                    MergeResult documentMergeResult = mergedDocument.merge(previousDocument, nextDocument, this.configuration.getMergeConfiguration(), context);
                    if (documentMergeResult.isModified()) {
                        if (this.configuration.isInteractive() && !documentMergeResult.getErrors().isEmpty()) {
                            nextDocument.setCreatorReference(currentDocument.getCreatorReference());
                            mergedDocument.setCreatorReference(currentDocument.getCreatorReference());
                            DocumentReference userReference = this.getUserReference(context);
                            nextDocument.setAuthorReference(userReference);
                            nextDocument.setContentAuthorReference(userReference);
                            mergedDocument.setAuthorReference(userReference);
                            mergedDocument.setContentAuthorReference(userReference);
                            XWikiDocument documentToSave = this.askDocumentToSave(currentDocument, previousDocument, nextDocument, mergedDocument);
                            if (documentToSave != currentDocument) {
                                this.saveDocument(documentToSave, comment, context);
                            }
                        } else {
                            this.saveDocument(mergedDocument, comment, context);
                        }
                    }
                    this.mergeResult = new XarEntryMergeResult(new XarEntry((EntityReference)mergedDocument.getDocumentReference(), mergedDocument.getLanguage()), documentMergeResult);
                } else if (!currentDocument.equalsData(nextDocument)) {
                    XWikiDocument documentToSave;
                    if (this.configuration.isInteractive()) {
                        nextDocument.setCreatorReference(currentDocument.getCreatorReference());
                        DocumentReference userReference = this.getUserReference(context);
                        nextDocument.setAuthorReference(userReference);
                        nextDocument.setContentAuthorReference(userReference);
                        documentToSave = this.askDocumentToSave(currentDocument, previousDocument, nextDocument, null);
                    } else {
                        documentToSave = nextDocument;
                    }
                    if (documentToSave != currentDocument) {
                        this.saveDocument(documentToSave, comment, context);
                    }
                }
            } else {
                this.saveDocument(nextDocument, comment, context);
            }
        }
        catch (Exception e) {
            throw new SAXException("Failed to save document", e);
        }
    }

    private XWikiDocument getDatabaseDocument() throws ComponentLookupException, XWikiException {
        XWikiContext context = this.getXWikiContext();
        XWikiDocument document = this.getDocument();
        XWikiDocument existingDocument = context.getWiki().getDocument(document.getDocumentReference(), context);
        if (StringUtils.isNotEmpty((CharSequence)document.getLanguage())) {
            String defaultLanguage = existingDocument.getDefaultLanguage();
            XWikiDocument translatedDocument = existingDocument.getTranslatedDocument(document.getLanguage(), context);
            if (translatedDocument == existingDocument) {
                translatedDocument = new XWikiDocument(document.getDocumentReference());
                translatedDocument.setDefaultLanguage(defaultLanguage);
                translatedDocument.setTranslation(1);
                translatedDocument.setLanguage(document.getLanguage());
            }
            existingDocument = translatedDocument;
        }
        if (this.hasCurrentDocument == null) {
            this.hasCurrentDocument = !existingDocument.isNew();
        }
        return existingDocument;
    }

    private XWikiDocument getPreviousDocument() throws NotADocumentException, ParserConfigurationException, SAXException, IOException {
        XWikiDocument previousDocument = null;
        if (this.previousXarFile != null) {
            XWikiDocument document = this.getDocument();
            DocumentHandler documentHandler = new DocumentHandler(this.getComponentManager(), document.getWikiName());
            XarEntry realEntry = this.previousXarFile.getEntry(new EntityReference(document.getName(), EntityType.DOCUMENT, new EntityReference(document.getSpace(), EntityType.SPACE)), document.getRealLanguage());
            if (realEntry != null) {
                this.packager.parseDocument(this.previousXarFile.getInputStream(realEntry), documentHandler);
                previousDocument = documentHandler.getDocument();
            }
        }
        return previousDocument;
    }

    private void saveAttachment(XWikiAttachment attachment, String comment) throws SAXException {
        try {
            XWikiContext context = this.getXWikiContext();
            XWikiDocument document = this.getDocument();
            document.setAuthorReference(context.getUserReference());
            attachment.setAuthor(document.getAuthor());
            XWikiDocument dbDocument = this.getDatabaseDocument();
            XWikiAttachment dbAttachment = dbDocument.getAttachment(attachment.getFilename());
            if (dbAttachment == null) {
                dbDocument.getAttachmentList().add(attachment);
            } else {
                dbAttachment.setContent(attachment.getContentInputStream(context));
                dbAttachment.setFilename(attachment.getFilename());
                dbAttachment.setAuthor(attachment.getAuthor());
            }
            context.getWiki().saveDocument(dbDocument, comment, context);
            attachment.setAttachment_content(null);
            this.getDocument().getAttachmentList().add(attachment);
        }
        catch (Exception e) {
            throw new SAXException("Failed to save attachment [" + attachment + "]", e);
        }
    }

    @Override
    protected void endAttachment(String uri, String localName, String qName) throws SAXException {
        AttachmentHandler handler = (AttachmentHandler)this.getCurrentHandler();
        this.saveAttachment(handler.getAttachment(), "Import: add attachment");
    }

    @Override
    protected void endHandlerElement(String uri, String localName, String qName) throws SAXException {
        this.saveDocument(this.getDocument().getAttachmentList().isEmpty() ? "Import" : "Import: final save");
    }
}

