/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.Extension;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.internal.AbstractExtensionHandler;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.xar.internal.handler.UnsupportedNamespaceException;
import org.xwiki.extension.xar.internal.handler.packager.DefaultPackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.handler.packager.XarEntry;
import org.xwiki.extension.xar.internal.handler.packager.XarFile;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.job.Job;
import org.xwiki.job.JobContext;
import org.xwiki.job.Request;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Singleton
@Named(value="xar")
public class XarExtensionHandler
extends AbstractExtensionHandler {
    public static final String TYPE = "xar";
    protected static final String WIKI_NAMESPACEPREFIX = "wiki:";
    protected static final String PROPERTY_USERREFERENCE = "user.reference";
    protected static final String PROPERTY_CALLERREFERENCE = "caller.reference";
    protected static final String PROPERTY_CHECKRIGHTS = "checkrights";
    private static final String XWIKIPREFERENCES_FULLNAME = "XWiki.XWikiPreferences";
    private static final String RIGHTS_ADMIN = "admin";
    @Inject
    private Packager packager;
    @Inject
    @Named(value="xar")
    private InstalledExtensionRepository xarRepository;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private DocumentReferenceResolver<String> resolver;

    protected static String getWikiFromNamespace(String namespace) throws UnsupportedNamespaceException {
        String wiki = namespace;
        if (wiki != null) {
            if (wiki.startsWith(WIKI_NAMESPACEPREFIX)) {
                wiki = wiki.substring(WIKI_NAMESPACEPREFIX.length());
            } else {
                throw new UnsupportedNamespaceException("Unsupported namespace [" + namespace + "], only wiki:wikiid format is supported");
            }
        }
        return wiki;
    }

    protected static DocumentReference getRequestUserReference(String property, Request request) {
        Object obj = request.getProperty(property);
        if (obj instanceof DocumentReference) {
            return (DocumentReference)obj;
        }
        return null;
    }

    public void install(LocalExtension localExtension, String namespace, Request request) throws InstallException {
        if (!request.isRemote()) {
            String wiki;
            try {
                wiki = XarExtensionHandler.getWikiFromNamespace(namespace);
            }
            catch (UnsupportedNamespaceException e) {
                throw new InstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
            }
            this.install(null, localExtension, wiki, request);
        }
    }

    public void upgrade(LocalExtension previousLocalExtension, LocalExtension newLocalExtension, String namespace, Request request) throws InstallException {
        if (!request.isRemote()) {
            String wiki;
            try {
                wiki = XarExtensionHandler.getWikiFromNamespace(namespace);
            }
            catch (UnsupportedNamespaceException e) {
                throw new InstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
            }
            XarInstalledExtension previousXarExtension = (XarInstalledExtension)this.xarRepository.getInstalledExtension(previousLocalExtension.getId());
            if (previousXarExtension == null) {
                throw new InstallException("Failed to get xar extension [" + previousLocalExtension.getId() + "] from xar repository");
            }
            this.install(previousXarExtension, newLocalExtension, wiki, request);
        }
    }

    private void install(XarInstalledExtension previousExtension, LocalExtension localExtension, String wiki, Request request) throws InstallException {
        try {
            this.packager.importXAR(previousExtension != null ? new XarFile(new File(previousExtension.getFile().getAbsolutePath()), previousExtension.getPages()) : null, new File(localExtension.getFile().getAbsolutePath()), this.createPackageConfiguration(request, wiki));
        }
        catch (Exception e) {
            throw new InstallException("Failed to import xar for extension [" + localExtension + "]", (Throwable)e);
        }
    }

    public void uninstall(LocalExtension localExtension, String namespace, Request request) throws UninstallException {
        if (!request.isRemote()) {
            String wiki;
            try {
                wiki = XarExtensionHandler.getWikiFromNamespace(namespace);
            }
            catch (UnsupportedNamespaceException e) {
                throw new UninstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
            }
            try {
                XarInstalledExtension xarLocalExtension = (XarInstalledExtension)this.xarRepository.resolve(localExtension.getId());
                List<XarEntry> pages = xarLocalExtension.getPages();
                this.packager.unimportPages(pages, this.createPackageConfiguration(request, wiki));
            }
            catch (Exception e) {
                throw new UninstallException("Failed to get xar extension [" + localExtension.getId() + "] from xar repository", (Throwable)e);
            }
        }
    }

    private PackageConfiguration createPackageConfiguration(Request request, String wiki) {
        DefaultPackageConfiguration configuration = new DefaultPackageConfiguration();
        configuration.setInteractive(request.isInteractive());
        configuration.setUser(XarExtensionHandler.getRequestUserReference(PROPERTY_USERREFERENCE, request));
        configuration.setWiki(wiki);
        configuration.setLogEnabled(true);
        try {
            Job currentJob = ((JobContext)this.componentManager.getInstance(JobContext.class)).getCurrentJob();
            if (currentJob != null) {
                configuration.setJobStatus(currentJob.getStatus());
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to lookup JobContext, it will be impossible to do interactive install");
        }
        return configuration;
    }

    private String getRequestUserString(String property, Request request) {
        String str = null;
        if (request.containsProperty(property)) {
            DocumentReference reference = XarExtensionHandler.getRequestUserReference(property, request);
            str = reference != null ? (String)this.serializer.serialize((EntityReference)reference, new Object[0]) : "XWiki.XWikiGuest";
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAccessLevel(String wiki, String right, String document, Request request) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        boolean hasAccess = true;
        String currentWiki = xcontext.getDatabase();
        try {
            String user;
            xcontext.setDatabase(wiki != null ? wiki : xcontext.getMainXWiki());
            String caller = this.getRequestUserString(PROPERTY_CALLERREFERENCE, request);
            if (caller != null) {
                hasAccess = xcontext.getWiki().getRightService().hasAccessLevel(right, caller, document, xcontext);
            }
            if (hasAccess && (user = this.getRequestUserString(PROPERTY_USERREFERENCE, request)) != null) {
                hasAccess = xcontext.getWiki().getRightService().hasAccessLevel(right, user, document, xcontext);
            }
        }
        finally {
            xcontext.setDatabase(currentWiki);
        }
        return hasAccess;
    }

    public void checkInstall(Extension extension, String namespace, Request request) throws InstallException {
        String wiki;
        try {
            wiki = XarExtensionHandler.getWikiFromNamespace(namespace);
        }
        catch (UnsupportedNamespaceException e) {
            throw new InstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
        }
        if (request.getProperty(PROPERTY_CHECKRIGHTS) == Boolean.TRUE) {
            try {
                if (!this.hasAccessLevel(wiki, RIGHTS_ADMIN, XWIKIPREFERENCES_FULLNAME, request)) {
                    if (namespace == null) {
                        throw new InstallException(String.format("Admin right is required to install extension [%s]", extension.getId()));
                    }
                    throw new InstallException(String.format("Admin right is required to install extension [%s] on namespace [%s]", extension.getId(), namespace));
                }
            }
            catch (XWikiException e) {
                throw new InstallException("Failed to check rights", (Throwable)e);
            }
        }
    }

    public void checkUninstall(InstalledExtension extension, String namespace, Request request) throws UninstallException {
        String wiki;
        try {
            wiki = XarExtensionHandler.getWikiFromNamespace(namespace);
        }
        catch (UnsupportedNamespaceException e) {
            throw new UninstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
        }
        if (request.getProperty(PROPERTY_CHECKRIGHTS) == Boolean.TRUE) {
            try {
                if (!this.hasAccessLevel(wiki, RIGHTS_ADMIN, XWIKIPREFERENCES_FULLNAME, request)) {
                    if (namespace == null) {
                        throw new UninstallException(String.format("Admin right is required to uninstall extension [%s]", extension.getId()));
                    }
                    throw new UninstallException(String.format("Admin right is required to uninstall extension [%s] from namespace [%s]", extension.getId(), namespace));
                }
            }
            catch (XWikiException e) {
                throw new UninstallException("Failed to check rights", (Throwable)e);
            }
        }
    }
}

