/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.event.ExtensionUpgradedEvent;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.xar.internal.handler.XarExtensionHandler;
import org.xwiki.extension.xar.internal.handler.packager.DefaultPackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.handler.packager.XarEntry;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.job.Request;
import org.xwiki.job.event.JobFinishedEvent;
import org.xwiki.job.event.JobStartedEvent;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="XarExtensionJobFinishedListener")
public class XarExtensionJobFinishedListener
implements EventListener {
    private static final List<Event> EVENTS = Arrays.asList(new ExtensionUpgradedEvent(), new JobStartedEvent("install"), new JobFinishedEvent("install"));
    @Inject
    private Execution execution;
    @Inject
    @Named(value="xar")
    private Provider<InstalledExtensionRepository> xarRepositoryProvider;
    @Inject
    private Provider<Packager> packagerProvider;
    @Inject
    private Logger logger;

    public String getName() {
        return "XarExtensionJobFinishedListener";
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    private void pushUpgradeLevel() {
        Stack<UpgradedExtensionCollection> extensions = this.getUpgradedExtensionCollectionStack(true);
        extensions.push(null);
    }

    private UpgradedExtensionCollection popUninstallLevel() {
        Stack<UpgradedExtensionCollection> extensions = this.getUpgradedExtensionCollectionStack(false);
        if (extensions != null) {
            return extensions.pop();
        }
        return null;
    }

    private Stack<UpgradedExtensionCollection> getUpgradedExtensionCollectionStack(boolean create) {
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            Stack extensions = (Stack)context.getProperty("extension.xar.upgradedExtensions");
            if (extensions == null && create) {
                extensions = new Stack();
                context.setProperty("extension.xar.upgradedExtensions", extensions);
            }
            return extensions;
        }
        return null;
    }

    private UpgradedExtensionCollection getCurrentUpgradedExtensionCollection(boolean create) {
        Stack<UpgradedExtensionCollection> extensions = this.getUpgradedExtensionCollectionStack(false);
        if (extensions != null) {
            UpgradedExtensionCollection collection = extensions.peek();
            if (collection == null) {
                collection = new UpgradedExtensionCollection();
                extensions.set(extensions.size() - 1, collection);
            }
            return collection;
        }
        return null;
    }

    public void onEvent(Event event, Object o, Object o1) {
        if (event instanceof ExtensionUpgradedEvent) {
            this.onExtensionUpgradedEvent((ExtensionUpgradedEvent)event, (InstalledExtension)o, (InstalledExtension)o1);
        } else if (event instanceof JobStartedEvent) {
            this.onJobStartedEvent(event);
        } else {
            this.onJobFinishedEvent((JobFinishedEvent)event);
        }
    }

    private List<XarEntry> getPages(InstalledExtension extension) throws IOException {
        XarInstalledExtension xarExtension;
        List<XarEntry> pages = extension instanceof XarInstalledExtension ? ((XarInstalledExtension)extension).getPages() : ((xarExtension = (XarInstalledExtension)((InstalledExtensionRepository)this.xarRepositoryProvider.get()).getInstalledExtension(extension.getId())) == null ? ((Packager)this.packagerProvider.get()).getEntries(new File(extension.getFile().getAbsolutePath())) : xarExtension.getPages());
        return pages;
    }

    private void onExtensionUpgradedEvent(ExtensionUpgradedEvent event, InstalledExtension newExtension, InstalledExtension previousExtension) {
        UpgradedExtensionCollection upgradedPages = this.getCurrentUpgradedExtensionCollection(true);
        try {
            upgradedPages.addPrevious(XarExtensionHandler.getWikiFromNamespace(event.getNamespace()), this.getPages(previousExtension));
        }
        catch (Exception e) {
            this.logger.error("Failed to get pages from xar extension [{}]", (Object)previousExtension.getId(), (Object)e);
        }
        try {
            upgradedPages.addNew(XarExtensionHandler.getWikiFromNamespace(event.getNamespace()), this.getPages(newExtension));
        }
        catch (Exception e) {
            this.logger.error("Failed to get pages from xar extension [{}]", (Object)newExtension.getId(), (Object)e);
        }
    }

    private void onJobStartedEvent(Event event) {
        this.pushUpgradeLevel();
    }

    private void onJobFinishedEvent(JobFinishedEvent event) {
        UpgradedExtensionCollection collection = this.popUninstallLevel();
        if (collection != null && collection.previousEntries != null) {
            if (collection.newEntries != null) {
                for (Map.Entry<String, Set<XarEntry>> newWikiEntry : collection.newEntries.entrySet()) {
                    Set<XarEntry> previousEntries = collection.previousEntries.get(newWikiEntry.getKey());
                    if (previousEntries == null) continue;
                    for (XarEntry newEntry : newWikiEntry.getValue()) {
                        previousEntries.remove(newEntry);
                    }
                }
            }
            for (Map.Entry<String, Set<XarEntry>> previousWikiEntry : collection.previousEntries.entrySet()) {
                try {
                    ((Packager)this.packagerProvider.get()).unimportPages((Collection<XarEntry>)previousWikiEntry.getValue(), this.createPackageConfiguration(event.getRequest(), previousWikiEntry.getKey()));
                }
                catch (Exception e) {
                    this.logger.warn("Exception when cleaning pages removed since previous xar extension version", (Throwable)e);
                }
            }
        }
    }

    private PackageConfiguration createPackageConfiguration(Request request, String wiki) {
        DefaultPackageConfiguration configuration = new DefaultPackageConfiguration();
        configuration.setInteractive(false);
        configuration.setUser(XarExtensionHandler.getRequestUserReference("user.reference", request));
        configuration.setWiki(wiki);
        configuration.setLogEnabled(true);
        return configuration;
    }

    private static final class UpgradedExtensionCollection {
        public Map<String, Set<XarEntry>> previousEntries;
        public Map<String, Set<XarEntry>> newEntries;

        private UpgradedExtensionCollection() {
        }

        public void addPrevious(String namespace, Collection<XarEntry> previousEntries) {
            Set<XarEntry> entries;
            if (this.previousEntries == null) {
                this.previousEntries = new HashMap<String, Set<XarEntry>>();
            }
            if ((entries = this.previousEntries.get(namespace)) == null) {
                entries = new HashSet<XarEntry>();
                this.previousEntries.put(namespace, entries);
            }
            entries.addAll(previousEntries);
        }

        public void addNew(String namespace, Collection<XarEntry> newEntries) {
            Set<XarEntry> entries;
            if (this.newEntries == null) {
                this.newEntries = new HashMap<String, Set<XarEntry>>();
            }
            if ((entries = this.newEntries.get(namespace)) == null) {
                entries = new HashSet<XarEntry>();
                this.newEntries.put(namespace, entries);
            }
            entries.addAll(newEntries);
        }
    }
}

