/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.job;

import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.internal.AbstractInstallPlanJob;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepositoryException;
import org.xwiki.job.Request;

@Component
@Named(value="repairxar")
public class RepairXarJob
extends AbstractInstallPlanJob<InstallRequest> {
    public static final String JOBTYPE = "repairxar";
    @Inject
    private InstalledExtensionRepository installedRepository;
    @Inject
    private LocalExtensionRepository localRepository;

    public String getType() {
        return JOBTYPE;
    }

    protected InstallRequest castRequest(Request request) {
        InstallRequest installRequest = request instanceof InstallRequest ? (InstallRequest)request : new InstallRequest(request);
        return installRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() throws Exception {
        this.notifyPushLevelProgress(((InstallRequest)this.getRequest()).getExtensions().size());
        try {
            for (ExtensionId extensionId : ((InstallRequest)this.getRequest()).getExtensions()) {
                if (((InstallRequest)this.getRequest()).getNamespaces() != null) {
                    this.notifyPushLevelProgress(((InstallRequest)this.getRequest()).getNamespaces().size());
                    try {
                        for (String namespace : ((InstallRequest)this.getRequest()).getNamespaces()) {
                            this.repairExtension(extensionId, namespace, false);
                            this.notifyStepPropress();
                        }
                    }
                    finally {
                        this.notifyPopLevelProgress();
                    }
                } else {
                    this.repairExtension(extensionId, null, false);
                }
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LocalExtension getLocalXARExtension(ExtensionId extensionId) throws InstallException {
        LocalExtension localExtension = this.localRepository.getLocalExtension(extensionId);
        if (localExtension == null) {
            try {
                Extension extension = this.repositoryManager.resolve(extensionId);
                if (!extension.getType().equals("xar")) return localExtension;
                return this.localExtensionRepository.storeExtension(extension);
            }
            catch (ResolveException e) {
                throw new InstallException("Failed to find extension", (Throwable)e);
            }
            catch (LocalExtensionRepositoryException e) {
                throw new InstallException("Failed save extension in local reposiory", (Throwable)e);
            }
        }
        if (localExtension.getType().equals("xar")) return localExtension;
        return null;
    }

    private void repairExtension(ExtensionId extensionId, String namespace, boolean dependency) throws InstallException {
        this.logger.info("Repairing extension [{}] on namespace [{}]", (Object)extensionId, (Object)namespace);
        if (this.installedRepository.getInstalledExtension(extensionId.getId(), namespace) != null) {
            this.logger.info("Extension [{}] already installed on namespace [{}]", (Object)extensionId.getId(), (Object)namespace);
            return;
        }
        LocalExtension localExtension = this.getLocalXARExtension(extensionId);
        if (localExtension != null) {
            this.repairExtension(localExtension, namespace, dependency);
        }
    }

    private void repairExtension(LocalExtension localExtension, String namespace, boolean dependency) throws InstallException {
        for (ExtensionDependency extensionDependency : localExtension.getDependencies()) {
            if (extensionDependency.getVersionConstraint().getVersion() == null) {
                this.logger.warn("Can't repair extension dependency [{}] with version range ([{}]) since there is no way to know what has been installed", (Object)extensionDependency.getId(), (Object)extensionDependency.getVersionConstraint());
                continue;
            }
            try {
                this.repairExtension(new ExtensionId(extensionDependency.getId(), extensionDependency.getVersionConstraint().getVersion()), namespace, true);
            }
            catch (InstallException e) {
                this.logger.warn("Failed to repair dependency [{}]", (Object)extensionDependency, (Object)e);
            }
        }
        this.installedRepository.installExtension(localExtension, namespace, dependency);
        this.logger.info("Successfully Repaired extension [{}] on namespace [{}]", (Object)localExtension, (Object)namespace);
    }
}

