/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.repository;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.event.ExtensionUninstalledEvent;
import org.xwiki.extension.event.ExtensionUpgradedEvent;
import org.xwiki.extension.repository.AbstractExtensionRepository;
import org.xwiki.extension.repository.DefaultExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.ExtensionRepositoryDescriptor;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.result.CollectionIterableResult;
import org.xwiki.extension.repository.result.IterableResult;
import org.xwiki.extension.repository.search.SearchException;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component
@Singleton
@Named(value="xar")
public class XarInstalledExtensionRepository
extends AbstractExtensionRepository
implements InstalledExtensionRepository,
Initializable {
    private static final List<Event> EVENTS = Arrays.asList(new ExtensionInstalledEvent(), new ExtensionUninstalledEvent(), new ExtensionUpgradedEvent());
    @Inject
    private transient InstalledExtensionRepository installedRepository;
    @Inject
    private transient Packager packager;
    @Inject
    private transient ObservationManager observation;
    @Inject
    private Logger logger;
    private Map<ExtensionId, XarInstalledExtension> extensions = new ConcurrentHashMap<ExtensionId, XarInstalledExtension>();

    public void initialize() throws InitializationException {
        this.setDescriptor((ExtensionRepositoryDescriptor)new DefaultExtensionRepositoryDescriptor("xar", "xar", this.installedRepository.getDescriptor().getURI()));
        this.loadExtensions();
        this.observation.addListener(new EventListener(){

            public void onEvent(Event event, Object arg1, Object arg2) {
                LocalExtension extension = (LocalExtension)arg1;
                if (extension.getType().equals("xar")) {
                    XarInstalledExtensionRepository.this.updateXarExtension(extension);
                }
                if (arg2 != null) {
                    XarInstalledExtensionRepository.this.updateXarExtension((LocalExtension)arg2);
                }
            }

            public String getName() {
                return XarInstalledExtensionRepository.class.getName();
            }

            public List<Event> getEvents() {
                return EVENTS;
            }
        });
    }

    private void updateXarExtension(LocalExtension extension) {
        if (this.extensions.containsKey(extension.getId())) {
            if (!(extension instanceof InstalledExtension)) {
                this.removeXarExtension(extension.getId());
            }
        } else if (extension instanceof InstalledExtension) {
            try {
                this.addXarExtension((InstalledExtension)extension);
            }
            catch (IOException e) {
                this.logger.error("Failed to parse extension [" + extension + "]", (Throwable)e);
            }
        }
    }

    private void addXarExtension(InstalledExtension extension) throws IOException {
        XarInstalledExtension xarExtension = new XarInstalledExtension(extension, this, this.packager);
        this.extensions.put(extension.getId(), xarExtension);
    }

    private void removeXarExtension(ExtensionId extensionId) {
        this.extensions.remove(extensionId);
    }

    private void loadExtensions() {
        for (InstalledExtension localExtension : this.installedRepository.getInstalledExtensions()) {
            if (!localExtension.getType().equalsIgnoreCase("xar")) continue;
            try {
                this.addXarExtension(localExtension);
            }
            catch (IOException e) {
                this.logger.error("Failed to parse extension [" + localExtension + "]", (Throwable)e);
            }
        }
    }

    public InstalledExtension resolve(ExtensionId extensionId) throws ResolveException {
        InstalledExtension extension = (InstalledExtension)this.extensions.get(extensionId);
        if (extension == null) {
            throw new ResolveException("Extension [" + extensionId + "] does not exists or is not a xar extension");
        }
        return extension;
    }

    public InstalledExtension resolve(ExtensionDependency extensionDependency) throws ResolveException {
        InstalledExtension extension = this.installedRepository.resolve(extensionDependency);
        if ((extension = (InstalledExtension)this.extensions.get(extension.getId())) == null) {
            throw new ResolveException("Extension [" + extensionDependency + "] does not exists or is not a xar extension");
        }
        return extension;
    }

    public boolean exists(ExtensionId extensionId) {
        return this.extensions.containsKey(extensionId);
    }

    public IterableResult<Version> resolveVersions(String id, int offset, int nb) throws ResolveException {
        return this.installedRepository.resolveVersions(id, offset, nb);
    }

    public int countExtensions() {
        return this.extensions.size();
    }

    public Collection<InstalledExtension> getInstalledExtensions(String namespace) {
        ArrayList<InstalledExtension> installedExtensions = new ArrayList<InstalledExtension>(this.extensions.size());
        for (XarInstalledExtension localExtension : this.extensions.values()) {
            if (!localExtension.isInstalled(namespace)) continue;
            installedExtensions.add((InstalledExtension)localExtension);
        }
        return installedExtensions;
    }

    public Collection<InstalledExtension> getInstalledExtensions() {
        return this.extensions.values();
    }

    public InstalledExtension getInstalledExtension(ExtensionId extensionId) {
        return (InstalledExtension)this.extensions.get(extensionId);
    }

    public InstalledExtension getInstalledExtension(String id, String namespace) {
        Object extension = this.installedRepository.getInstalledExtension(id, namespace);
        extension = extension.getType().equals("xar") ? (InstalledExtension)this.extensions.get(extension.getId()) : null;
        return extension;
    }

    public InstalledExtension installExtension(LocalExtension extension, String namespace, boolean dependency) throws InstallException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void uninstallExtension(InstalledExtension extension, String namespace) throws UninstallException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Collection<InstalledExtension> getBackwardDependencies(String id, String namespace) throws ResolveException {
        InstalledExtension extension = this.installedRepository.getInstalledExtension(id, namespace);
        return extension.getType().equals("xar") ? this.installedRepository.getBackwardDependencies(id, namespace) : null;
    }

    public Map<String, Collection<InstalledExtension>> getBackwardDependencies(ExtensionId extensionId) throws ResolveException {
        InstalledExtension extension = this.installedRepository.resolve(extensionId);
        return extension.getType().equals("xar") ? this.installedRepository.getBackwardDependencies(extensionId) : null;
    }

    public IterableResult<Extension> search(String pattern, int offset, int nb) throws SearchException {
        Pattern patternMatcher = Pattern.compile(".*" + pattern + ".*");
        ArrayList<XarInstalledExtension> result = new ArrayList<XarInstalledExtension>();
        for (XarInstalledExtension extension : this.extensions.values()) {
            if (!patternMatcher.matcher(extension.getId().getId()).matches() && !patternMatcher.matcher(extension.getDescription()).matches() && !patternMatcher.matcher(extension.getSummary()).matches() && !patternMatcher.matcher(extension.getName()).matches() && !patternMatcher.matcher(extension.getFeatures().toString()).matches()) continue;
            result.add(extension);
        }
        return new CollectionIterableResult(this.extensions.size(), offset, result);
    }
}

