/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.script;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.internal.safe.ScriptSafeProvider;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobManager;
import org.xwiki.job.Request;

@Component
@Named(value="xarextension")
@Singleton
public class XarExtensionScriptService {
    public static final String EXTENSIONERROR_KEY = "scriptservice.xarextension.error";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private Execution execution;
    @Inject
    private ScriptSafeProvider scriptProvider;
    @Inject
    private JobManager jobManager;
    @Inject
    private InstalledExtensionRepository xarRepository;

    private <T> T safe(T unsafe) {
        return (T)this.scriptProvider.get(unsafe);
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(EXTENSIONERROR_KEY);
    }

    private void setError(Exception e) {
        this.execution.getContext().setProperty(EXTENSIONERROR_KEY, (Object)e);
    }

    public Job repairInstalledExtension(String id, String version, String wiki) {
        this.setError(null);
        if (!this.documentAccessBridge.hasProgrammingRights()) {
            this.setError((Exception)new JobException("Need programming right to repair a XAR"));
            return null;
        }
        String namespace = "wiki:" + wiki;
        InstallRequest installRequest = new InstallRequest();
        installRequest.setId(this.getJobId("action", id, namespace));
        installRequest.addExtension(new ExtensionId(id, version));
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            installRequest.addNamespace(namespace);
        }
        Job job = null;
        try {
            job = this.jobManager.addJob("repairxar", (Request)installRequest);
        }
        catch (Exception e) {
            this.setError(e);
        }
        return job;
    }

    private List<String> getJobId(String prefix, String extensionId, String namespace) {
        List<String> jobId = namespace != null ? Arrays.asList("extension", prefix, extensionId, namespace) : Arrays.asList("extension", prefix, extensionId);
        return jobId;
    }
}

