/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.MandatoryDocumentInitializer;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.doc.merge.MergeResult;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.xar.internal.handler.ConflictQuestion;
import org.xwiki.extension.xar.internal.handler.packager.DocumentMergeImporter;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.XarEntry;
import org.xwiki.extension.xar.internal.handler.packager.XarEntryMergeResult;
import org.xwiki.logging.LogLevel;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Singleton
public class DefaultDocumentMergeImporter
implements DocumentMergeImporter {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManager;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localSerializer;
    @Inject
    private Logger logger;

    @Override
    public XarEntryMergeResult saveDocument(String comment, XWikiDocument previousDocument, XWikiDocument currentDocument, XWikiDocument nextDocument, PackageConfiguration configuration) throws Exception {
        XarEntryMergeResult mergeResult = null;
        if (configuration.isLogEnabled()) {
            this.logger.info("Importing document [{}] in language [{}]...", (Object)nextDocument.getDocumentReference(), (Object)nextDocument.getRealLocale());
        }
        if (currentDocument != null && !currentDocument.isNew()) {
            if (previousDocument != null) {
                mergeResult = this.merge(comment, currentDocument, previousDocument, nextDocument, configuration);
            } else {
                XWikiDocument mandatoryDocument = this.getMandatoryDocument(nextDocument.getDocumentReference());
                if (mandatoryDocument != null) {
                    mergeResult = this.merge(comment, currentDocument, mandatoryDocument, nextDocument, configuration);
                } else if (!currentDocument.equalsData(nextDocument)) {
                    XWikiDocument documentToSave;
                    if (configuration.isInteractive()) {
                        nextDocument.setCreatorReference(currentDocument.getCreatorReference());
                        DocumentReference userReference = configuration.getUserReference();
                        nextDocument.setAuthorReference(userReference);
                        nextDocument.setContentAuthorReference(userReference);
                        documentToSave = this.askDocumentToSave(currentDocument, previousDocument, nextDocument, null, configuration);
                    } else {
                        documentToSave = nextDocument;
                    }
                    if (documentToSave != currentDocument) {
                        this.saveDocument(documentToSave, comment, false, configuration);
                    }
                }
            }
        } else {
            this.saveDocument(nextDocument, comment, true, configuration);
        }
        return mergeResult;
    }

    private XarEntryMergeResult merge(String comment, XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, PackageConfiguration configuration) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument mergedDocument = currentDocument.clone();
        MergeConfiguration mergeConfiguration = new MergeConfiguration();
        mergeConfiguration.setProvidedVersionsModifiables(true);
        MergeResult documentMergeResult = mergedDocument.merge(previousDocument, nextDocument, mergeConfiguration, xcontext);
        if (configuration.isInteractive() && !documentMergeResult.getLog().getLogs(LogLevel.ERROR).isEmpty()) {
            XWikiDocument documentToSave;
            nextDocument.setCreatorReference(currentDocument.getCreatorReference());
            mergedDocument.setCreatorReference(currentDocument.getCreatorReference());
            DocumentReference userReference = configuration.getUserReference();
            if (userReference != null) {
                nextDocument.setAuthorReference(userReference);
                nextDocument.setContentAuthorReference(userReference);
                mergedDocument.setAuthorReference(userReference);
                mergedDocument.setContentAuthorReference(userReference);
            }
            if ((documentToSave = this.askDocumentToSave(currentDocument, previousDocument, nextDocument, mergedDocument, configuration)) != currentDocument) {
                this.saveDocument(documentToSave, comment, false, configuration);
            }
        } else if (documentMergeResult.isModified()) {
            this.saveDocument(mergedDocument, comment, false, configuration);
        }
        return new XarEntryMergeResult(new XarEntry((EntityReference)mergedDocument.getDocumentReference(), mergedDocument.getLocale()), documentMergeResult);
    }

    private XWikiDocument getMandatoryDocument(DocumentReference documentReference) {
        XWikiDocument mandatoryDocument;
        MandatoryDocumentInitializer initializer;
        try {
            initializer = (MandatoryDocumentInitializer)((ComponentManager)this.componentManager.get()).getInstance(MandatoryDocumentInitializer.class, (String)this.serializer.serialize((EntityReference)documentReference, new Object[0]));
        }
        catch (ComponentLookupException e) {
            try {
                initializer = (MandatoryDocumentInitializer)((ComponentManager)this.componentManager.get()).getInstance(MandatoryDocumentInitializer.class, (String)this.localSerializer.serialize((EntityReference)documentReference, new Object[0]));
            }
            catch (ComponentLookupException e1) {
                initializer = null;
            }
        }
        if (initializer != null) {
            mandatoryDocument = new XWikiDocument(documentReference);
            if (!initializer.updateDocument(mandatoryDocument)) {
                mandatoryDocument = null;
            }
        } else {
            mandatoryDocument = null;
        }
        return mandatoryDocument;
    }

    private XWikiDocument askDocumentToSave(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, XWikiDocument mergedDocument, PackageConfiguration configuration) {
        XWikiDocument documentToSave;
        ConflictQuestion question = new ConflictQuestion(currentDocument, previousDocument, nextDocument, mergedDocument);
        if (mergedDocument == null) {
            question.setGlobalAction(ConflictQuestion.GlobalAction.NEXT);
        }
        if (configuration != null && configuration.getJobStatus() != null) {
            try {
                configuration.getJobStatus().ask((Object)question);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        switch (question.getGlobalAction()) {
            case CURRENT: {
                documentToSave = currentDocument;
                break;
            }
            case NEXT: {
                documentToSave = nextDocument;
                break;
            }
            case PREVIOUS: {
                documentToSave = previousDocument;
                break;
            }
            case CUSTOM: {
                documentToSave = question.getCustomDocument() != null ? question.getCustomDocument() : mergedDocument;
                break;
            }
            default: {
                documentToSave = mergedDocument;
            }
        }
        return documentToSave;
    }

    private XWikiDocument getDatabaseDocument(XWikiDocument document, XWikiContext context) throws XWikiException {
        XWikiDocument existingDocument = context.getWiki().getDocument(document.getDocumentReference(), context);
        if (!document.getLocale().equals(Locale.ROOT)) {
            Locale defaultLocale = existingDocument.getDefaultLocale();
            XWikiDocument translatedDocument = existingDocument.getTranslatedDocument(document.getLocale(), context);
            if (translatedDocument == existingDocument) {
                translatedDocument = new XWikiDocument(document.getDocumentReference());
                translatedDocument.setDefaultLocale(defaultLocale);
                translatedDocument.setTranslation(1);
                translatedDocument.setLocale(document.getLocale());
            }
            existingDocument = translatedDocument;
        }
        return existingDocument;
    }

    private void saveDocument(XWikiDocument document, String comment, boolean setCreator, PackageConfiguration configuration) throws Exception {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument currentDocument = this.getDatabaseDocument(document, context);
        DocumentReference userReference = configuration.getUserReference();
        if (!currentDocument.isNew()) {
            if (document != currentDocument) {
                if (document.isNew()) {
                    currentDocument.apply(document);
                    if (setCreator) {
                        currentDocument.setCreatorReference(document.getCreatorReference());
                    }
                    currentDocument.setAuthorReference(document.getAuthorReference());
                    currentDocument.setContentAuthorReference(document.getContentAuthorReference());
                } else {
                    currentDocument = document;
                }
            }
        } else {
            currentDocument = document;
        }
        if (userReference != null) {
            if (setCreator) {
                currentDocument.setCreatorReference(userReference);
            }
            currentDocument.setAuthorReference(userReference);
            currentDocument.setContentAuthorReference(userReference);
        }
        this.saveDocumentSetContextUser(currentDocument, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDocumentSetContextUser(XWikiDocument document, String comment) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        DocumentReference userReference = xcontext.getUserReference();
        try {
            xcontext.setUserReference(document.getAuthorReference());
            xcontext.getWiki().saveDocument(document, comment, false, xcontext);
        }
        finally {
            xcontext.setUserReference(userReference);
        }
    }
}

