/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XARImportedEvent;
import com.xpn.xwiki.internal.event.XARImportingEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.slf4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.xar.internal.handler.packager.DocumentMergeImporter;
import org.xwiki.extension.xar.internal.handler.packager.NotADocumentException;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.handler.packager.XarEntry;
import org.xwiki.extension.xar.internal.handler.packager.XarMergeResult;
import org.xwiki.extension.xar.internal.handler.packager.xml.DocumentImporterHandler;
import org.xwiki.extension.xar.internal.handler.packager.xml.RootHandler;
import org.xwiki.extension.xar.internal.handler.packager.xml.UnknownRootElement;
import org.xwiki.extension.xar.internal.handler.packager.xml.XarPageLimitedHandler;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Component
@Singleton
public class DefaultPackager
implements Packager,
Initializable {
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="explicit")
    private DocumentReferenceResolver<EntityReference> resolver;
    @Inject
    private Logger logger;
    @Inject
    private ObservationManager observation;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DocumentMergeImporter importer;
    private SAXParserFactory parserFactory;

    public void initialize() throws InitializationException {
        this.parserFactory = SAXParserFactory.newInstance();
    }

    @Override
    public void importXAR(File xarFile, PackageConfiguration configuration) throws IOException, XWikiException, ComponentLookupException {
        if (configuration.getWiki() == null) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            List wikis = xcontext.getWiki().getVirtualWikisDatabaseNames(xcontext);
            for (String subwiki : wikis) {
                this.importXARToWiki(xarFile, subwiki, configuration);
            }
        } else {
            this.importXARToWiki(xarFile, configuration.getWiki(), configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XarMergeResult importXARToWiki(File xarFile, String wiki, PackageConfiguration configuration) throws IOException, ComponentLookupException {
        FileInputStream fis = new FileInputStream(xarFile);
        try {
            XarMergeResult xarMergeResult = this.importXARToWiki(fis, wiki, configuration);
            return xarMergeResult;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XarMergeResult importXARToWiki(InputStream xarInputStream, String wiki, PackageConfiguration configuration) throws IOException, ComponentLookupException {
        XarMergeResult mergeResult = new XarMergeResult();
        ZipArchiveInputStream zis = new ZipArchiveInputStream(xarInputStream);
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        String currentWiki = xcontext.getDatabase();
        try {
            xcontext.setDatabase(wiki);
            this.observation.notify((Event)new XARImportingEvent(), null, (Object)xcontext);
            ArchiveEntry entry = zis.getNextEntry();
            while (entry != null) {
                block10: {
                    if (!entry.isDirectory() && (configuration.getEntriesToImport() == null || configuration.getEntriesToImport().contains(entry.getName()))) {
                        DocumentImporterHandler documentHandler = new DocumentImporterHandler(this, this.componentManager, wiki, this.importer);
                        try {
                            documentHandler.setConfiguration(configuration);
                            this.parseDocument((InputStream)zis, documentHandler);
                            if (documentHandler.getMergeResult() != null) {
                                mergeResult.addMergeResult(documentHandler.getMergeResult());
                            }
                            if (configuration.isLogEnabled()) {
                                this.logger.info("Successfully imported document [{}] in language [{}]", (Object)documentHandler.getDocument().getDocumentReference(), (Object)documentHandler.getDocument().getRealLocale());
                            }
                        }
                        catch (NotADocumentException e) {
                            this.logger.debug("Entry [" + entry + "] is not a document", (Throwable)e);
                        }
                        catch (Exception e) {
                            this.logger.error("Failed to parse document [" + entry.getName() + "]", (Throwable)e);
                            if (!configuration.isLogEnabled()) break block10;
                            this.logger.info("Failed to import document [{}] in language [{}]", (Object)documentHandler.getDocument().getDocumentReference(), (Object)documentHandler.getDocument().getRealLocale());
                        }
                    }
                }
                entry = zis.getNextEntry();
            }
        }
        finally {
            this.observation.notify((Event)new XARImportedEvent(), null, (Object)xcontext);
            xcontext.setDatabase(currentWiki);
        }
        return mergeResult;
    }

    @Override
    public void unimportXAR(File xarFile, PackageConfiguration configuration) throws IOException, XWikiException {
        if (configuration.getWiki() == null) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            List wikis = xcontext.getWiki().getVirtualWikisDatabaseNames(xcontext);
            for (String subwiki : wikis) {
                this.unimportXARFromWiki(xarFile, subwiki, configuration);
            }
        } else {
            this.unimportXARFromWiki(xarFile, configuration.getWiki(), configuration);
        }
    }

    private void unimportXARFromWiki(File xarFile, String wiki, PackageConfiguration configuration) throws IOException {
        this.unimportPagesFromWiki(this.getEntries(xarFile), wiki, configuration);
    }

    @Override
    public void unimportPages(Collection<XarEntry> pages, PackageConfiguration configuration) throws XWikiException {
        if (configuration.getWiki() == null) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            List wikis = xcontext.getWiki().getVirtualWikisDatabaseNames(xcontext);
            for (String subwiki : wikis) {
                this.unimportPagesFromWiki(pages, subwiki, configuration);
            }
        } else {
            this.unimportPagesFromWiki(pages, configuration.getWiki(), configuration);
        }
    }

    private void unimportPagesFromWiki(Collection<XarEntry> pages, String wiki, PackageConfiguration configuration) {
        WikiReference wikiReference = new WikiReference(wiki);
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        for (XarEntry xarEntry : pages) {
            if (configuration.getEntriesToImport() != null && !configuration.getEntriesToImport().contains(xarEntry.getEntryName())) continue;
            DocumentReference documentReference = this.resolver.resolve((Object)xarEntry.getDocumentReference(), new Object[]{wikiReference});
            try {
                XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
                if (document.isNew()) continue;
                Locale locale = xarEntry.getLocale();
                if (locale != null && !Locale.ROOT.equals(locale)) {
                    document = document.getTranslatedDocument(locale, xcontext);
                }
                xcontext.getWiki().deleteDocument(document, xcontext);
                this.logger.info("Successfully deleted document [{}] in language [{}]", (Object)document.getDocumentReference(), (Object)document.getRealLocale());
            }
            catch (XWikiException e) {
                this.logger.error("Failed to delete document [{}]", (Object)documentReference, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<XarEntry> getEntries(File xarFile) throws IOException {
        List<XarEntry> documents = null;
        FileInputStream fis = new FileInputStream(xarFile);
        ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)fis);
        try {
            ZipArchiveEntry zipEntry = zis.getNextZipEntry();
            while (zipEntry != null) {
                if (!zipEntry.isDirectory()) {
                    try {
                        XarPageLimitedHandler documentHandler = new XarPageLimitedHandler(this.componentManager);
                        this.parseDocument((InputStream)zis, documentHandler);
                        if (documents == null) {
                            documents = new ArrayList<XarEntry>();
                        }
                        XarEntry xarEntry = documentHandler.getXarEntry();
                        xarEntry.setEntryName(zipEntry.getName());
                        documents.add(xarEntry);
                    }
                    catch (NotADocumentException e) {
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to parse document [" + zipEntry.getName() + "]", (Throwable)e);
                    }
                }
                zipEntry = zis.getNextZipEntry();
            }
        }
        finally {
            fis.close();
        }
        return documents != null ? documents : Collections.emptyList();
    }

    public void parseDocument(InputStream in, ContentHandler documentHandler) throws ParserConfigurationException, SAXException, IOException, NotADocumentException {
        SAXParser saxParser = this.parserFactory.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        RootHandler handler = new RootHandler(this.componentManager);
        handler.setHandler("xwikidoc", documentHandler);
        xmlReader.setContentHandler(handler);
        try {
            xmlReader.parse(new InputSource((InputStream)new CloseShieldInputStream(in)));
        }
        catch (UnknownRootElement e) {
            throw new NotADocumentException("Failed to parse stream", e);
        }
    }
}

