/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionException;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.UninstallException;
import org.xwiki.extension.handler.internal.AbstractExtensionHandler;
import org.xwiki.extension.job.plan.ExtensionPlan;
import org.xwiki.extension.job.plan.ExtensionPlanAction;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.xar.internal.handler.UnsupportedNamespaceException;
import org.xwiki.extension.xar.internal.handler.packager.DefaultPackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.Packager;
import org.xwiki.extension.xar.internal.handler.packager.XarEntry;
import org.xwiki.extension.xar.internal.handler.packager.XarFile;
import org.xwiki.extension.xar.internal.repository.XarInstalledExtension;
import org.xwiki.job.Job;
import org.xwiki.job.JobContext;
import org.xwiki.job.Request;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Singleton
@Named(value="xar")
public class XarExtensionHandler
extends AbstractExtensionHandler {
    public static final String TYPE = "xar";
    public static final String CONTEXTKEY_PREVIOUSXARPAGES = "extension.xar.installplan.previouspages";
    public static final String CONTEXTKEY_XARPAGES = "extension.xar.installplan.pages";
    protected static final String WIKI_NAMESPACEPREFIX = "wiki:";
    protected static final String PROPERTY_USERREFERENCE = "user.reference";
    protected static final String PROPERTY_CALLERREFERENCE = "caller.reference";
    protected static final String PROPERTY_CHECKRIGHTS = "checkrights";
    private static final String XWIKIPREFERENCES_FULLNAME = "XWiki.XWikiPreferences";
    private static final String RIGHTS_ADMIN = "admin";
    @Inject
    private Packager packager;
    @Inject
    @Named(value="xar")
    private InstalledExtensionRepository xarRepository;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private LocalExtensionRepository localReposirory;
    @Inject
    private Execution execution;

    protected static String getWikiFromNamespace(String namespace) throws UnsupportedNamespaceException {
        String wiki = namespace;
        if (wiki != null) {
            if (wiki.startsWith(WIKI_NAMESPACEPREFIX)) {
                wiki = wiki.substring(WIKI_NAMESPACEPREFIX.length());
            } else {
                throw new UnsupportedNamespaceException("Unsupported namespace [" + namespace + "], only wiki:wikiid format is supported");
            }
        }
        return wiki;
    }

    protected static DocumentReference getRequestUserReference(String property, Request request) {
        Object obj = request.getProperty(property);
        if (obj instanceof DocumentReference) {
            return (DocumentReference)obj;
        }
        return null;
    }

    private void initializePagesIndex() throws ExtensionException {
        ExtensionPlan plan;
        ExecutionContext context = this.execution.getContext();
        if (context != null && (plan = (ExtensionPlan)context.getProperty("job.extension.plan")) != null) {
            HashMap<String, HashMap<XarEntry, XarInstalledExtension>> previousXAREntries = (HashMap<String, HashMap<XarEntry, XarInstalledExtension>>)context.getProperty(CONTEXTKEY_PREVIOUSXARPAGES);
            HashMap<String, HashMap<XarEntry, LocalExtension>> nextXAREntries = (HashMap<String, HashMap<XarEntry, LocalExtension>>)context.getProperty(CONTEXTKEY_XARPAGES);
            if (nextXAREntries == null) {
                previousXAREntries = new HashMap<String, HashMap<XarEntry, XarInstalledExtension>>();
                nextXAREntries = new HashMap<String, HashMap<XarEntry, LocalExtension>>();
                for (ExtensionPlanAction action : plan.getActions()) {
                    if (!action.getExtension().getType().equals(TYPE)) continue;
                    Collection previousExtensions = action.getPreviousExtensions();
                    for (InstalledExtension previousExtension : previousExtensions) {
                        if (previousExtension == null) continue;
                        XarInstalledExtension previousXARExtension = (XarInstalledExtension)this.xarRepository.getInstalledExtension(previousExtension.getId());
                        for (XarEntry entry : previousXARExtension.getPages()) {
                            String wiki;
                            try {
                                wiki = XarExtensionHandler.getWikiFromNamespace(action.getNamespace());
                            }
                            catch (UnsupportedNamespaceException e) {
                                throw new ExtensionException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
                            }
                            HashMap<XarEntry, XarInstalledExtension> pages = (HashMap<XarEntry, XarInstalledExtension>)previousXAREntries.get(wiki);
                            if (pages == null) {
                                pages = new HashMap<XarEntry, XarInstalledExtension>();
                                previousXAREntries.put(wiki, pages);
                            }
                            pages.put(entry, previousXARExtension);
                        }
                    }
                    LocalExtension nextExtension = action.getAction() != ExtensionPlanAction.Action.UNINSTALL && action.getExtension() != null ? this.localReposirory.getLocalExtension(action.getExtension().getId()) : null;
                    if (nextExtension == null) continue;
                    try {
                        List<XarEntry> entries = this.packager.getEntries(new File(nextExtension.getFile().getAbsolutePath()));
                        for (XarEntry entry : entries) {
                            String wiki;
                            try {
                                wiki = XarExtensionHandler.getWikiFromNamespace(action.getNamespace());
                            }
                            catch (UnsupportedNamespaceException e) {
                                throw new ExtensionException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
                            }
                            HashMap<XarEntry, LocalExtension> pages = (HashMap<XarEntry, LocalExtension>)nextXAREntries.get(wiki);
                            if (pages == null) {
                                pages = new HashMap<XarEntry, LocalExtension>();
                                nextXAREntries.put(wiki, pages);
                            }
                            pages.put(entry, nextExtension);
                        }
                    }
                    catch (IOException e) {
                        this.logger.error("Failed to parse extension file [{}]", (Object)nextExtension.getFile().getAbsolutePath(), (Object)e);
                    }
                }
                context.setProperty(CONTEXTKEY_PREVIOUSXARPAGES, previousXAREntries);
                context.setProperty(CONTEXTKEY_XARPAGES, nextXAREntries);
            }
        }
    }

    private Map<String, Map<XarEntry, XarInstalledExtension>> getPreviousXAREntries() {
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            return (Map)context.getProperty(CONTEXTKEY_PREVIOUSXARPAGES);
        }
        return null;
    }

    private Map<String, Map<XarEntry, LocalExtension>> getNextXAREntries() {
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            return (Map)context.getProperty(CONTEXTKEY_XARPAGES);
        }
        return null;
    }

    public void install(LocalExtension localExtension, String namespace, Request request) throws InstallException {
        if (!request.isRemote()) {
            String wiki;
            try {
                wiki = XarExtensionHandler.getWikiFromNamespace(namespace);
            }
            catch (UnsupportedNamespaceException e) {
                throw new InstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
            }
            this.installInternal(localExtension, wiki, request);
        }
    }

    public void upgrade(Collection<InstalledExtension> previousLocalExtensions, LocalExtension newLocalExtension, String namespace, Request request) throws InstallException {
        if (!request.isRemote()) {
            String wiki;
            try {
                wiki = XarExtensionHandler.getWikiFromNamespace(namespace);
            }
            catch (UnsupportedNamespaceException e) {
                throw new InstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
            }
            this.installInternal(newLocalExtension, wiki, request);
        }
    }

    private void installInternal(LocalExtension newLocalExtension, String wiki, Request request) throws InstallException {
        try {
            this.initializePagesIndex();
        }
        catch (ExtensionException e) {
            throw new InstallException("Failed to initialize extension plan index", (Throwable)e);
        }
        PackageConfiguration configuration = this.createPackageConfiguration(newLocalExtension, request, wiki);
        try {
            this.packager.importXAR(new File(newLocalExtension.getFile().getAbsolutePath()), configuration);
        }
        catch (Exception e) {
            throw new InstallException("Failed to import xar for extension [" + newLocalExtension + "]", (Throwable)e);
        }
        finally {
            this.cleanPackageConfiguration(configuration);
        }
    }

    public void uninstall(InstalledExtension installedExtension, String namespace, Request request) throws UninstallException {
        try {
            this.initializePagesIndex();
        }
        catch (ExtensionException e) {
            throw new UninstallException("Failed to initialize extension plan index", (Throwable)e);
        }
        if (!request.isRemote()) {
            Job currentJob;
            try {
                currentJob = ((JobContext)this.componentManager.getInstance(JobContext.class)).getCurrentJob();
            }
            catch (ComponentLookupException e1) {
                currentJob = null;
            }
            if (currentJob == null) {
                String wiki;
                try {
                    wiki = XarExtensionHandler.getWikiFromNamespace(namespace);
                }
                catch (UnsupportedNamespaceException e) {
                    throw new UninstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
                }
                PackageConfiguration configuration = this.createPackageConfiguration(null, request, wiki);
                try {
                    XarInstalledExtension xarLocalExtension = (XarInstalledExtension)this.xarRepository.resolve(installedExtension.getId());
                    List<XarEntry> pages = xarLocalExtension.getPages();
                    this.packager.unimportPages(pages, configuration);
                }
                catch (Exception e) {
                    throw new UninstallException("Failed to get xar extension [" + installedExtension.getId() + "] from xar repository", (Throwable)e);
                }
                finally {
                    this.cleanPackageConfiguration(configuration);
                }
            }
        }
    }

    private void cleanPackageConfiguration(PackageConfiguration configuration) {
        for (XarFile xarFile : configuration.getPreviousPages().values()) {
            try {
                xarFile.close();
            }
            catch (IOException e) {
                this.logger.warn("Failed to close XARFile [{}]", (Object)xarFile, (Object)e);
            }
        }
    }

    private PackageConfiguration createPackageConfiguration(LocalExtension extension, Request request, String wiki) {
        Map<XarEntry, XarInstalledExtension> previousXAREntriesOnWiki;
        DefaultPackageConfiguration configuration = new DefaultPackageConfiguration();
        configuration.setInteractive(request.isInteractive());
        configuration.setUser(XarExtensionHandler.getRequestUserReference(PROPERTY_USERREFERENCE, request));
        configuration.setWiki(wiki);
        configuration.setLogEnabled(true);
        configuration.setSkipMandatorytDocuments(true);
        try {
            Job currentJob = ((JobContext)this.componentManager.getInstance(JobContext.class)).getCurrentJob();
            if (currentJob != null) {
                configuration.setJobStatus(currentJob.getStatus());
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to lookup JobContext, it will be impossible to do interactive install");
        }
        Map<String, Map<XarEntry, XarInstalledExtension>> previousXAREntries = this.getPreviousXAREntries();
        HashMap<XarEntry, XarFile> previousPages = new HashMap<XarEntry, XarFile>();
        Map<XarEntry, XarInstalledExtension> previousXAREntriesOnRoot = previousXAREntries.get(null);
        if (previousXAREntriesOnRoot != null) {
            for (Map.Entry<XarEntry, XarInstalledExtension> entry : previousXAREntriesOnRoot.entrySet()) {
                try {
                    previousPages.put(entry.getKey(), new XarFile(new File(entry.getValue().getFile().getAbsolutePath()), entry.getValue().getPages()));
                }
                catch (IOException e) {
                    this.logger.error("Failed to create XARFile for installed extension [{}]", (Object)entry.getValue(), (Object)e);
                }
            }
        }
        if ((previousXAREntriesOnWiki = previousXAREntries.get(wiki)) != null) {
            for (Map.Entry<XarEntry, XarInstalledExtension> entry : previousXAREntriesOnWiki.entrySet()) {
                try {
                    previousPages.put(entry.getKey(), new XarFile(new File(entry.getValue().getFile().getAbsolutePath()), entry.getValue().getPages()));
                }
                catch (IOException e) {
                    this.logger.error("Failed to create XARFile for installed extension [{}]", (Object)entry.getValue(), (Object)e);
                }
            }
        }
        configuration.setPreviousPages(previousPages);
        if (extension != null) {
            Map<XarEntry, LocalExtension> nextXAREntriesOnWiki;
            Map<String, Map<XarEntry, LocalExtension>> nextXAREntries = this.getNextXAREntries();
            HashSet<String> entriesToImport = new HashSet<String>();
            Map<XarEntry, LocalExtension> nextXAREntriesOnRoot = nextXAREntries.get(null);
            if (nextXAREntriesOnRoot != null) {
                for (Map.Entry<XarEntry, LocalExtension> entry : nextXAREntriesOnRoot.entrySet()) {
                    if (entry.getValue() != extension) continue;
                    entriesToImport.add(entry.getKey().getEntryName());
                }
            }
            if ((nextXAREntriesOnWiki = nextXAREntries.get(wiki)) != null) {
                for (Map.Entry<XarEntry, LocalExtension> entry : nextXAREntriesOnWiki.entrySet()) {
                    if (entry.getValue() != extension) continue;
                    entriesToImport.add(entry.getKey().getEntryName());
                }
            }
            configuration.setEntriesToImport(entriesToImport);
        }
        return configuration;
    }

    private String getRequestUserString(String property, Request request) {
        String str = null;
        if (request.containsProperty(property)) {
            DocumentReference reference = XarExtensionHandler.getRequestUserReference(property, request);
            str = reference != null ? (String)this.serializer.serialize((EntityReference)reference, new Object[0]) : "XWiki.XWikiGuest";
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAccessLevel(String wiki, String right, String document, Request request) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        boolean hasAccess = true;
        String currentWiki = xcontext.getDatabase();
        try {
            String user;
            xcontext.setDatabase(wiki != null ? wiki : xcontext.getMainXWiki());
            if (request.getProperty(PROPERTY_CALLERREFERENCE) != null) {
                String caller = this.getRequestUserString(PROPERTY_CALLERREFERENCE, request);
                hasAccess = xcontext.getWiki().getRightService().hasAccessLevel(right, caller, document, xcontext);
            }
            if (hasAccess && (user = this.getRequestUserString(PROPERTY_USERREFERENCE, request)) != null) {
                hasAccess = xcontext.getWiki().getRightService().hasAccessLevel(right, user, document, xcontext);
            }
        }
        finally {
            xcontext.setDatabase(currentWiki);
        }
        return hasAccess;
    }

    public void checkInstall(Extension extension, String namespace, Request request) throws InstallException {
        String wiki;
        try {
            wiki = XarExtensionHandler.getWikiFromNamespace(namespace);
        }
        catch (UnsupportedNamespaceException e) {
            throw new InstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
        }
        if (request.getProperty(PROPERTY_CHECKRIGHTS) == Boolean.TRUE) {
            try {
                if (!this.hasAccessLevel(wiki, RIGHTS_ADMIN, XWIKIPREFERENCES_FULLNAME, request)) {
                    if (namespace == null) {
                        throw new InstallException(String.format("Admin right is required to install extension [%s]", extension.getId()));
                    }
                    throw new InstallException(String.format("Admin right is required to install extension [%s] on namespace [%s]", extension.getId(), namespace));
                }
            }
            catch (XWikiException e) {
                throw new InstallException("Failed to check rights", (Throwable)e);
            }
        }
    }

    public void checkUninstall(InstalledExtension extension, String namespace, Request request) throws UninstallException {
        String wiki;
        try {
            wiki = XarExtensionHandler.getWikiFromNamespace(namespace);
        }
        catch (UnsupportedNamespaceException e) {
            throw new UninstallException("Failed to extract wiki id from namespace", (Throwable)((Object)e));
        }
        if (request.getProperty(PROPERTY_CHECKRIGHTS) == Boolean.TRUE) {
            try {
                if (!this.hasAccessLevel(wiki, RIGHTS_ADMIN, XWIKIPREFERENCES_FULLNAME, request)) {
                    if (namespace == null) {
                        throw new UninstallException(String.format("Admin right is required to uninstall extension [%s]", extension.getId()));
                    }
                    throw new UninstallException(String.format("Admin right is required to uninstall extension [%s] from namespace [%s]", extension.getId(), namespace));
                }
            }
            catch (XWikiException e) {
                throw new UninstallException("Failed to check rights", (Throwable)e);
            }
        }
    }
}

