/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.job;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.extension.Extension;
import org.xwiki.extension.ExtensionDependency;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.InstallException;
import org.xwiki.extension.InstalledExtension;
import org.xwiki.extension.LocalExtension;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.event.ExtensionInstalledEvent;
import org.xwiki.extension.job.InstallRequest;
import org.xwiki.extension.job.internal.AbstractExtensionJob;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.repository.InstalledExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepository;
import org.xwiki.extension.repository.LocalExtensionRepositoryException;
import org.xwiki.job.Request;
import org.xwiki.job.internal.DefaultJobStatus;
import org.xwiki.observation.event.Event;

@Component
@Named(value="repairxar")
public class RepairXarJob
extends AbstractExtensionJob<InstallRequest, DefaultJobStatus<InstallRequest>> {
    public static final String JOBTYPE = "repairxar";
    @Inject
    protected ExtensionRepositoryManager repositoryManager;
    @Inject
    private InstalledExtensionRepository installedRepository;
    @Inject
    private LocalExtensionRepository localRepository;

    public String getType() {
        return JOBTYPE;
    }

    protected InstallRequest castRequest(Request request) {
        InstallRequest installRequest = request instanceof InstallRequest ? (InstallRequest)request : new InstallRequest(request);
        return installRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runInternal() throws Exception {
        this.notifyPushLevelProgress(((InstallRequest)this.getRequest()).getExtensions().size());
        try {
            for (ExtensionId extensionId : ((InstallRequest)this.getRequest()).getExtensions()) {
                if (((InstallRequest)this.getRequest()).getNamespaces() != null) {
                    this.notifyPushLevelProgress(((InstallRequest)this.getRequest()).getNamespaces().size());
                    try {
                        for (String namespace : ((InstallRequest)this.getRequest()).getNamespaces()) {
                            this.repairExtension(extensionId, namespace, false);
                            this.notifyStepPropress();
                        }
                    }
                    finally {
                        this.notifyPopLevelProgress();
                    }
                } else {
                    this.repairExtension(extensionId, null, false);
                }
                this.notifyStepPropress();
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LocalExtension getLocalXARExtension(ExtensionId extensionId) throws InstallException {
        LocalExtension localExtension = this.localRepository.getLocalExtension(extensionId);
        if (localExtension == null) {
            this.notifyPushLevelProgress(2);
            try {
                Extension extension = this.repositoryManager.resolve(extensionId);
                this.notifyStepPropress();
                if (!extension.getType().equals("xar")) return localExtension;
                localExtension = this.localExtensionRepository.storeExtension(extension);
                return localExtension;
            }
            catch (ResolveException e) {
                throw new InstallException("Failed to find extension", (Throwable)e);
            }
            catch (LocalExtensionRepositoryException e) {
                throw new InstallException("Failed save extension in local repository", (Throwable)e);
            }
            finally {
                this.notifyPopLevelProgress();
            }
        } else {
            if (localExtension.getType().equals("xar")) return localExtension;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairExtension(ExtensionId extensionId, String namespace, boolean dependency) throws InstallException {
        this.logger.info("Repairing extension [{}] on namespace [{}]", (Object)extensionId, (Object)namespace);
        if (this.installedRepository.getInstalledExtension(extensionId.getId(), namespace) != null) {
            this.logger.info("Extension [{}] already installed on namespace [{}]", (Object)extensionId.getId(), (Object)namespace);
            return;
        }
        this.notifyPushLevelProgress(2);
        try {
            LocalExtension localExtension = this.getLocalXARExtension(extensionId);
            this.notifyStepPropress();
            if (localExtension != null) {
                this.repairExtension(localExtension, namespace, dependency);
            }
        }
        finally {
            this.notifyPopLevelProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairExtension(LocalExtension localExtension, String namespace, boolean dependency) throws InstallException {
        this.notifyPushLevelProgress(2);
        try {
            Collection dependencies = localExtension.getDependencies();
            if (!dependencies.isEmpty()) {
                this.notifyPushLevelProgress(dependencies.size());
                try {
                    for (ExtensionDependency extensionDependency : dependencies) {
                        this.repairDependency(extensionDependency, namespace);
                        this.notifyStepPropress();
                    }
                }
                finally {
                    this.notifyPopLevelProgress();
                }
            }
            this.notifyStepPropress();
            InstalledExtension installedExtension = this.installedRepository.installExtension(localExtension, namespace, dependency);
            this.observationManager.notify((Event)new ExtensionInstalledEvent(installedExtension.getId(), namespace), (Object)installedExtension);
        }
        finally {
            this.notifyPopLevelProgress();
        }
        this.logger.info("Successfully Repaired extension [{}] on namespace [{}]", (Object)localExtension, (Object)namespace);
    }

    private void repairDependency(ExtensionDependency extensionDependency, String namespace) {
        if (extensionDependency.getVersionConstraint().getVersion() == null) {
            this.logger.warn("Can't repair extension dependency [{}] with version range ([{}]) since there is no way to know what has been installed", (Object)extensionDependency.getId(), (Object)extensionDependency.getVersionConstraint());
        } else {
            try {
                this.repairExtension(new ExtensionId(extensionDependency.getId(), extensionDependency.getVersionConstraint().getVersion()), namespace, true);
            }
            catch (InstallException e) {
                this.logger.warn("Failed to repair dependency [{}]", (Object)extensionDependency, (Object)e);
            }
        }
    }
}

