/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.xar.internal.handler.packager;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.MandatoryDocumentInitializer;
import com.xpn.xwiki.doc.MandatoryDocumentInitializerManager;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.doc.merge.MergeConfiguration;
import com.xpn.xwiki.doc.merge.MergeResult;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.extension.xar.internal.handler.packager.PackageConfiguration;
import org.xwiki.extension.xar.internal.handler.packager.XarEntryMergeResult;
import org.xwiki.extension.xar.question.ConflictQuestion;
import org.xwiki.logging.LogLevel;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.xar.XarEntry;

@Component(roles={DocumentMergeImporter.class})
@Singleton
public class DocumentMergeImporter {
    static final String PROP_ALWAYS_MERGE = "extension.xar.packager.conflict.always.merge";
    static final String PROP_ALWAYS_NOMERGE = "extension.xar.packager.conflict.always.nomerge";
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private MandatoryDocumentInitializerManager initializerManager;
    @Inject
    private Execution execution;
    @Inject
    private Logger logger;

    public XarEntryMergeResult saveDocument(String comment, XWikiDocument previousDocument, XWikiDocument currentDocument, XWikiDocument nextDocument, PackageConfiguration configuration) throws Exception {
        XarEntryMergeResult mergeResult = null;
        if (currentDocument != null && !currentDocument.isNew()) {
            if (previousDocument != null) {
                mergeResult = this.merge(comment, currentDocument, previousDocument, nextDocument, configuration);
            } else {
                XWikiDocument mandatoryDocument = this.getMandatoryDocument(nextDocument.getDocumentReference());
                if (mandatoryDocument != null) {
                    mergeResult = this.merge(comment, currentDocument, mandatoryDocument, nextDocument, configuration);
                } else if (!currentDocument.equalsData(nextDocument)) {
                    XWikiDocument documentToSave;
                    if (configuration.isInteractive()) {
                        nextDocument.setCreatorReference(currentDocument.getCreatorReference());
                        DocumentReference userReference = configuration.getUserReference();
                        if (userReference != null) {
                            nextDocument.setAuthorReference(userReference);
                            nextDocument.setContentAuthorReference(userReference);
                            for (XWikiAttachment attachment : nextDocument.getAttachmentList()) {
                                attachment.setAuthor(nextDocument.getAuthor());
                            }
                        }
                        documentToSave = this.askDocumentToSave(currentDocument, previousDocument, nextDocument, null, configuration);
                    } else {
                        documentToSave = nextDocument;
                    }
                    if (documentToSave != currentDocument) {
                        this.saveDocument(documentToSave, comment, false, configuration);
                    }
                }
            }
        } else if (previousDocument == null) {
            this.saveDocument(nextDocument, comment, true, configuration);
        }
        return mergeResult;
    }

    private XarEntryMergeResult merge(String comment, XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, PackageConfiguration configuration) throws Exception {
        MergeResult documentMergeResult;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument mergedDocument = currentDocument.clone();
        MergeConfiguration mergeConfiguration = new MergeConfiguration();
        mergeConfiguration.setProvidedVersionsModifiables(true);
        try {
            documentMergeResult = mergedDocument.merge(previousDocument, nextDocument, mergeConfiguration, xcontext);
        }
        catch (Exception e) {
            documentMergeResult = new MergeResult();
            documentMergeResult.getLog().error("Unexpected exception thrown. Usually means there is a bug in the merge.", (Throwable)e);
            documentMergeResult.setModified(true);
        }
        documentMergeResult.getLog().log(this.logger);
        if (configuration.isInteractive() && !documentMergeResult.getLog().getLogs(LogLevel.ERROR).isEmpty()) {
            XWikiDocument documentToSave;
            nextDocument.setCreatorReference(currentDocument.getCreatorReference());
            mergedDocument.setCreatorReference(currentDocument.getCreatorReference());
            DocumentReference userReference = configuration.getUserReference();
            if (userReference != null) {
                nextDocument.setAuthorReference(userReference);
                nextDocument.setContentAuthorReference(userReference);
                for (XWikiAttachment attachment : nextDocument.getAttachmentList()) {
                    attachment.setAuthor(nextDocument.getAuthor());
                }
                mergedDocument.setAuthorReference(userReference);
                mergedDocument.setContentAuthorReference(userReference);
                for (XWikiAttachment attachment : mergedDocument.getAttachmentList()) {
                    if (!attachment.isContentDirty()) continue;
                    attachment.setAuthor(mergedDocument.getAuthor());
                }
            }
            if ((documentToSave = this.askDocumentToSave(currentDocument, previousDocument, nextDocument, mergedDocument, configuration)) != currentDocument) {
                this.saveDocument(documentToSave, comment, false, configuration);
            }
        } else if (documentMergeResult.isModified()) {
            this.saveDocument(mergedDocument, comment, false, configuration);
        }
        return new XarEntryMergeResult(new XarEntry(new LocalDocumentReference(mergedDocument.getDocumentReferenceWithLocale())), documentMergeResult);
    }

    private XWikiDocument getMandatoryDocument(DocumentReference documentReference) {
        XWikiDocument mandatoryDocument;
        MandatoryDocumentInitializer initializer = this.initializerManager.getMandatoryDocumentInitializer(documentReference);
        if (initializer != null) {
            mandatoryDocument = new XWikiDocument(documentReference);
            if (!initializer.updateDocument(mandatoryDocument)) {
                mandatoryDocument = null;
            }
        } else {
            mandatoryDocument = null;
        }
        return mandatoryDocument;
    }

    private ConflictQuestion.GlobalAction getMergeConflictAnswer(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument) {
        return (ConflictQuestion.GlobalAction)((Object)this.execution.getContext().getProperty(previousDocument != null ? PROP_ALWAYS_MERGE : PROP_ALWAYS_NOMERGE));
    }

    private void setMergeConflictAnswer(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, ConflictQuestion.GlobalAction action) {
        this.execution.getContext().setProperty(previousDocument != null ? PROP_ALWAYS_MERGE : PROP_ALWAYS_NOMERGE, (Object)action);
    }

    private XWikiDocument askDocumentToSave(XWikiDocument currentDocument, XWikiDocument previousDocument, XWikiDocument nextDocument, XWikiDocument mergedDocument, PackageConfiguration configuration) {
        XWikiDocument documentToSave;
        ConflictQuestion question = new ConflictQuestion(currentDocument, previousDocument, nextDocument, mergedDocument);
        if (mergedDocument == null) {
            question.setGlobalAction(ConflictQuestion.GlobalAction.NEXT);
        }
        if (configuration != null && configuration.getJobStatus() != null) {
            ConflictQuestion.GlobalAction contextAction = this.getMergeConflictAnswer(currentDocument, previousDocument, nextDocument);
            if (contextAction != null) {
                question.setGlobalAction(contextAction);
            } else {
                try {
                    configuration.getJobStatus().ask((Object)question);
                    if (question.isAlways()) {
                        this.setMergeConflictAnswer(currentDocument, previousDocument, nextDocument, question.getGlobalAction());
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        switch (question.getGlobalAction()) {
            case CURRENT: {
                documentToSave = currentDocument;
                break;
            }
            case NEXT: {
                documentToSave = nextDocument;
                break;
            }
            case PREVIOUS: {
                documentToSave = previousDocument;
                break;
            }
            case CUSTOM: {
                documentToSave = question.getCustomDocument() != null ? question.getCustomDocument() : mergedDocument;
                break;
            }
            default: {
                documentToSave = mergedDocument;
            }
        }
        return documentToSave;
    }

    private void saveDocument(XWikiDocument document, String comment, boolean setCreator, PackageConfiguration configuration) throws Exception {
        DocumentReference configuredUser;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument currentDocument = xcontext.getWiki().getDocument(document.getDocumentReferenceWithLocale(), xcontext);
        if (!currentDocument.isNew()) {
            if (document != currentDocument) {
                if (document.isNew()) {
                    currentDocument.loadAttachmentsContent(xcontext);
                    currentDocument.apply(document);
                } else {
                    currentDocument = document;
                }
            }
        } else {
            currentDocument = document;
        }
        if ((configuredUser = configuration.getUserReference()) != null) {
            if (setCreator) {
                currentDocument.setCreatorReference(configuredUser);
            }
            currentDocument.setAuthorReference(configuredUser);
            currentDocument.setContentAuthorReference(configuredUser);
            for (XWikiAttachment attachment : currentDocument.getAttachmentList()) {
                if (!attachment.isContentDirty()) continue;
                attachment.setAuthor(currentDocument.getAuthor());
            }
        } else {
            if (document != currentDocument) {
                if (setCreator) {
                    currentDocument.setCreatorReference(document.getCreatorReference());
                }
                currentDocument.setAuthorReference(document.getAuthorReference());
                currentDocument.setContentAuthorReference(document.getContentAuthorReference());
                for (XWikiAttachment attachment : document.getAttachmentList()) {
                    if (!attachment.isContentDirty()) continue;
                    currentDocument.getAttachment(attachment.getFilename()).setAuthor(attachment.getAuthor());
                }
            }
            currentDocument.setContentDirty(false);
            currentDocument.setContentUpdateDate(new Date());
        }
        this.saveDocumentSetContextUser(currentDocument, comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDocumentSetContextUser(XWikiDocument document, String comment) throws Exception {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        DocumentReference userReference = xcontext.getUserReference();
        try {
            xcontext.setUserReference(document.getAuthorReference());
            xcontext.getWiki().saveDocument(document, comment, false, xcontext);
        }
        finally {
            xcontext.setUserReference(userReference);
        }
    }
}

